/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationContext;
import eu.europa.esig.dss.validation.AbstractCertificateValidator;
import eu.europa.esig.dss.validation.executor.certificate.CertificateProcessExecutor;
import eu.europa.esig.dss.validation.executor.certificate.DefaultCertificateProcessExecutor;
import eu.europa.esig.dss.validation.reports.CertificateReports;
import java.util.Objects;

public class CertificateValidator
extends AbstractCertificateValidator<CertificateReports, CertificateProcessExecutor> {
    private static final String CERTIFICATE_VALIDATION_POLICY_LOCATION = "/policy/certificate-constraint.xml";
    private final CertificateToken token;

    private CertificateValidator(CertificateToken token) {
        this.token = token;
    }

    public static CertificateValidator fromCertificate(CertificateToken token) {
        Objects.requireNonNull(token, "The certificate is missing");
        return new CertificateValidator(token);
    }

    @Override
    protected String getDefaultValidationPolicyPath() {
        return CERTIFICATE_VALIDATION_POLICY_LOCATION;
    }

    @Override
    protected ValidationContext prepareValidationContext(CertificateVerifier certificateVerifier) {
        ValidationContext svc = super.prepareValidationContext(certificateVerifier);
        svc.addCertificateTokenForVerification(this.token);
        return svc;
    }

    @Override
    protected CertificateProcessExecutor provideProcessExecutorInstance() {
        if (this.processExecutor == null) {
            this.processExecutor = this.getDefaultProcessExecutor();
        }
        ((CertificateProcessExecutor)this.processExecutor).setCertificateId(this.identifierProvider.getIdAsString(this.token));
        return (CertificateProcessExecutor)this.processExecutor;
    }

    @Override
    public CertificateProcessExecutor getDefaultProcessExecutor() {
        return new DefaultCertificateProcessExecutor();
    }

    @Override
    protected void assertConfigurationValid() {
        super.assertConfigurationValid();
        Objects.requireNonNull(this.token, "Certificate token is not provided to the validator");
    }
}

