/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.runnable;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.client.http.DSSFileLoader;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessByKey;
import eu.europa.esig.dss.tsl.download.XmlDownloadResult;
import eu.europa.esig.dss.tsl.download.XmlDownloadTask;
import eu.europa.esig.dss.tsl.parsing.AbstractParsingResult;
import eu.europa.esig.dss.tsl.parsing.AbstractParsingTask;
import eu.europa.esig.dss.tsl.source.TLSource;
import eu.europa.esig.dss.tsl.validation.TLValidatorTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnalysis {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAnalysis.class);
    private final TLSource source;
    private final CacheAccessByKey cacheAccess;
    private final DSSFileLoader dssFileLoader;

    protected AbstractAnalysis(TLSource source, CacheAccessByKey cacheAccess, DSSFileLoader dssFileLoader) {
        this.source = source;
        this.cacheAccess = cacheAccess;
        this.dssFileLoader = dssFileLoader;
    }

    protected final TLSource getSource() {
        return this.source;
    }

    protected final CacheAccessByKey getCacheAccessByKey() {
        return this.cacheAccess;
    }

    protected DSSDocument download(String url) {
        DSSDocument document = null;
        try {
            LOG.debug("Downloading url '{}'...", (Object)url);
            XmlDownloadTask downloadTask = new XmlDownloadTask(this.dssFileLoader, url);
            XmlDownloadResult downloadResult = downloadTask.get();
            if (!this.cacheAccess.isUpToDate(downloadResult)) {
                this.cacheAccess.update(downloadResult);
                this.expireCache();
            }
            document = downloadResult.getDSSDocument();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage());
            this.cacheAccess.downloadError(e);
        }
        return document;
    }

    protected void expireCache() {
        this.cacheAccess.expireParsing();
        this.cacheAccess.expireValidation();
    }

    protected void parsing(DSSDocument document) {
        if (this.cacheAccess.isParsingRefreshNeeded()) {
            try {
                LOG.debug("Parsing the TL/LOTL with cache key '{}'...", (Object)this.cacheAccess.getCacheKey().getKey());
                AbstractParsingTask<?> parsingTask = this.getParsingTask(document);
                this.cacheAccess.update((AbstractParsingResult)parsingTask.get());
            }
            catch (Exception e) {
                LOG.warn("Cannot parse the TL/LOTL with the cache key '{}' : {}", this.cacheAccess.getCacheKey().getKey(), e.getMessage(), e);
                this.cacheAccess.parsingError(e);
            }
        }
    }

    protected abstract AbstractParsingTask<?> getParsingTask(DSSDocument var1);

    protected void validation(DSSDocument document, CertificateSource certificateSource) {
        if (this.cacheAccess.isValidationRefreshNeeded()) {
            try {
                LOG.debug("Validating the TL/LOTL with cache key '{}'...", (Object)this.cacheAccess.getCacheKey().getKey());
                TLValidatorTask validationTask = this.getValidationTask(document, certificateSource);
                this.cacheAccess.update(validationTask.get());
            }
            catch (Exception e) {
                LOG.warn("Cannot validate the TL/LOTL with the cache key '{}' : {}", (Object)this.cacheAccess.getCacheKey().getKey(), (Object)e.getMessage());
                this.cacheAccess.validationError(e);
            }
        }
    }

    protected TLValidatorTask getValidationTask(DSSDocument document, CertificateSource certificateSource) {
        return new TLValidatorTask(document, certificateSource);
    }
}

