/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.task;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import javafx.scene.control.ChoiceDialog;

public class SelectCertificateTask
implements Callable<DSSPrivateKeyEntry> {
    private List<DSSPrivateKeyEntry> keys;

    public SelectCertificateTask(List<DSSPrivateKeyEntry> keys2) {
        this.keys = keys2;
    }

    @Override
    public DSSPrivateKeyEntry call() {
        HashMap<CallSite, DSSPrivateKeyEntry> map = new HashMap<CallSite, DSSPrivateKeyEntry>();
        for (DSSPrivateKeyEntry dssPrivateKeyEntry : this.keys) {
            CertificateToken certificate = dssPrivateKeyEntry.getCertificate();
            String text = DSSASN1Utils.getHumanReadableName(certificate) + " (" + String.valueOf(certificate.getSerialNumber()) + ")";
            map.put((CallSite)((Object)text), dssPrivateKeyEntry);
        }
        Set keySet = map.keySet();
        ChoiceDialog<String> dialog = new ChoiceDialog<String>((String)keySet.iterator().next(), keySet);
        dialog.setHeaderText("Select your certificate");
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (DSSPrivateKeyEntry)map.get(result.get());
        }
        return null;
    }
}

