/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.source;

import eu.europa.esig.dss.spi.x509.CommonTrustedCertificateSource;
import eu.europa.esig.dss.spi.x509.KeyStoreCertificateSource;
import eu.europa.esig.dss.standalone.source.PropertyReader;
import eu.europa.esig.dss.standalone.source.TSPSourceLoader;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedCertificateSourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedCertificateSourceLoader.class);
    private static CommonTrustedCertificateSource trustedCertificateSource;

    public static CommonTrustedCertificateSource getTrustedCertificateSource() {
        if (trustedCertificateSource == null) {
            trustedCertificateSource = TrustedCertificateSourceLoader.loadTrustedCertificateSource();
        }
        return trustedCertificateSource;
    }

    private static CommonTrustedCertificateSource loadTrustedCertificateSource() {
        CommonTrustedCertificateSource trustedCertificateSource = new CommonTrustedCertificateSource();
        String ksFilePath = PropertyReader.getProperty("trusted.source.keystore.filename");
        String ksType = PropertyReader.getProperty("trusted.source.keystore.type");
        char[] ksPassword = PropertyReader.getCharArrayProperty("trusted.source.keystore.password");
        if (Utils.isStringNotEmpty(ksFilePath)) {
            try (InputStream is = TSPSourceLoader.class.getResourceAsStream(ksFilePath);){
                KeyStoreCertificateSource keyStore = new KeyStoreCertificateSource(is, ksType, ksPassword);
                trustedCertificateSource.importAsTrusted(keyStore);
            }
            catch (IOException e) {
                LOG.error("Unable to load a trusted key store: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return trustedCertificateSource;
    }
}

