/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.crl;

import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.utils.Utils;
import java.io.InputStream;
import java.util.List;

public class ExternalResourcesCRLSource
extends OfflineCRLSource {
    private static final long serialVersionUID = -985602836642741439L;

    public ExternalResourcesCRLSource(String ... paths) {
        for (String pathItem : paths) {
            this.addCRLToken(this.getClass().getResourceAsStream(pathItem));
        }
    }

    public ExternalResourcesCRLSource(InputStream ... inputStreams) {
        for (InputStream inputStream : inputStreams) {
            this.addCRLToken(inputStream);
        }
    }

    public ExternalResourcesCRLSource(DSSDocument ... dssDocuments) {
        for (DSSDocument document : dssDocuments) {
            this.addCRLToken(document.openStream());
        }
    }

    private void addCRLToken(InputStream inputStream) {
        try (InputStream is = inputStream;){
            this.addBinary(CRLUtils.buildCRLBinary(Utils.toByteArray(is)), RevocationOrigin.EXTERNAL);
        }
        catch (Exception e) {
            throw new DSSException("Unable to parse the stream (CRL is expected)", e);
        }
    }

    @Override
    public List<RevocationToken<CRL>> getRevocationTokens(CertificateToken certificate, CertificateToken issuer) {
        List<RevocationToken<CRL>> revocationTokens = super.getRevocationTokens(certificate, issuer);
        for (RevocationToken<CRL> revocationToken : revocationTokens) {
            revocationToken.setExternalOrigin(RevocationOrigin.EXTERNAL);
        }
        return revocationTokens;
    }
}

