/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.evidencerecord;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.SignatureAttribute;
import eu.europa.esig.dss.spi.validation.evidencerecord.EmbeddedEvidenceRecordHelper;
import eu.europa.esig.dss.spi.validation.evidencerecord.SignatureEvidenceRecordDigestBuilder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEmbeddedEvidenceRecordHelper
implements EmbeddedEvidenceRecordHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEmbeddedEvidenceRecordHelper.class);
    protected final AdvancedSignature signature;
    protected final SignatureAttribute evidenceRecordAttribute;
    private Integer orderOfAttribute;
    private Integer orderWithinAttribute;
    private List<DSSDocument> detachedContents;

    protected AbstractEmbeddedEvidenceRecordHelper(AdvancedSignature signature) {
        this(signature, null);
    }

    protected AbstractEmbeddedEvidenceRecordHelper(AdvancedSignature signature, SignatureAttribute evidenceRecordAttribute) {
        this.signature = signature;
        this.evidenceRecordAttribute = evidenceRecordAttribute;
    }

    @Override
    public AdvancedSignature getMasterSignature() {
        return this.signature;
    }

    @Override
    public SignatureAttribute getEvidenceRecordAttribute() {
        return this.evidenceRecordAttribute;
    }

    @Override
    public Integer getOrderOfAttribute() {
        return this.orderOfAttribute;
    }

    public void setOrderOfAttribute(Integer orderOfAttribute) {
        this.orderOfAttribute = orderOfAttribute;
    }

    @Override
    public Integer getOrderWithinAttribute() {
        return this.orderWithinAttribute;
    }

    public void setOrderWithinAttribute(Integer orderWithinAttribute) {
        this.orderWithinAttribute = orderWithinAttribute;
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return this.detachedContents;
    }

    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public Digest getMasterSignatureDigest(DigestAlgorithm digestAlgorithm) {
        SignatureEvidenceRecordDigestBuilder digestBuilder = this.getDigestBuilder(this.signature, this.evidenceRecordAttribute, digestAlgorithm);
        return this.buildDigest(digestBuilder);
    }

    @Override
    public Digest getMasterSignatureDigest(DigestAlgorithm digestAlgorithm, boolean derEncoded) {
        SignatureEvidenceRecordDigestBuilder digestBuilder = this.getDigestBuilder(this.signature, this.evidenceRecordAttribute, digestAlgorithm);
        this.setDEREncoding(digestBuilder, derEncoded);
        return this.buildDigest(digestBuilder);
    }

    private Digest buildDigest(SignatureEvidenceRecordDigestBuilder digestBuilder) {
        try {
            return digestBuilder.build();
        }
        catch (Exception e) {
            String errorMessage = "Unable to compute master signature digest for an evidence record. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
            } else {
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
            return new Digest();
        }
    }

    protected abstract SignatureEvidenceRecordDigestBuilder getDigestBuilder(AdvancedSignature var1, SignatureAttribute var2, DigestAlgorithm var3);

    protected abstract void setDEREncoding(SignatureEvidenceRecordDigestBuilder var1, boolean var2);
}

