/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.security;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.security.DSSP7CCertificatesSecurityFactory;
import eu.europa.esig.dss.spi.security.DSSSecurityFactory;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Provider;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DSSCertificateTokenSecurityFactory<I>
extends DSSSecurityFactory<I, CertificateToken> {
    private static final Logger LOG = LoggerFactory.getLogger(DSSCertificateTokenSecurityFactory.class);
    public static final DSSCertificateTokenSecurityFactory<InputStream> INPUT_STREAM_INSTANCE = new DSSCertificateTokenSecurityFactory<InputStream>(){

        @Override
        protected String toString(InputStream input) {
            return "InputStream";
        }

        @Override
        public CertificateToken build(InputStream input) {
            CertificateToken certificateToken = (CertificateToken)this.buildWithPrimarySecurityProvider(input);
            if (certificateToken != null) {
                return certificateToken;
            }
            throw new DSSException(String.format("Unable to load %s for the given certificate %s. All security providers have failed. More detail in debug mode.", this.getFactoryClassName(), input.getClass().getSimpleName()));
        }

        @Override
        protected CertificateToken buildWithProvider(InputStream input, Provider securityProvider) throws Exception {
            List certificateTokens = (List)DSSP7CCertificatesSecurityFactory.INPUT_STREAM_INSTANCE.buildWithProvider(input, securityProvider);
            if (certificateTokens == null || certificateTokens.size() == 0) {
                throw new DSSException("Could not parse certificate.");
            }
            if (certificateTokens.size() == 1) {
                return (CertificateToken)certificateTokens.get(0);
            }
            throw new DSSException(String.format("'%s' certificate obtained instead of one. Please provide a single certificate to load or use a different method to read multiple certificates.", certificateTokens.size()));
        }
    };
    public static final DSSCertificateTokenSecurityFactory<byte[]> BINARY_INSTANCE = new DSSCertificateTokenSecurityFactory<byte[]>(){

        @Override
        protected String toString(byte[] input) {
            return input != null ? Utils.toBase64(input) : null;
        }

        @Override
        protected CertificateToken buildWithProvider(byte[] input, Provider securityProvider) throws Exception {
            return (CertificateToken)INPUT_STREAM_INSTANCE.buildWithProvider(new ByteArrayInputStream(input), securityProvider);
        }
    };
    public static final DSSCertificateTokenSecurityFactory<File> FILE_INSTANCE = new DSSCertificateTokenSecurityFactory<File>(){

        @Override
        protected String toString(File input) {
            return input != null ? input.getPath() : null;
        }

        @Override
        protected CertificateToken buildWithProvider(File input, Provider securityProvider) throws Exception {
            try {
                return (CertificateToken)INPUT_STREAM_INSTANCE.buildWithProvider(Files.newInputStream(input.toPath(), new OpenOption[0]), securityProvider);
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to find a file '%s' : %s", input.getPath(), e.getMessage()), e);
            }
        }
    };
    public static final DSSCertificateTokenSecurityFactory<X509CertificateHolder> X509_CERTIFICATE_HOLDER_INSTANCE = new DSSCertificateTokenSecurityFactory<X509CertificateHolder>(){

        @Override
        protected String toString(X509CertificateHolder input) {
            try {
                return input != null ? Utils.toBase64(input.getEncoded()) : null;
            }
            catch (IOException e) {
                LOG.warn("Unable to read encoded binaries of X509CertificateHolder : {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }

        @Override
        protected CertificateToken buildWithProvider(X509CertificateHolder input, Provider securityProvider) throws Exception {
            JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
            jcaX509CertificateConverter.setProvider(securityProvider);
            X509Certificate certificate = jcaX509CertificateConverter.getCertificate(input);
            return new CertificateToken(certificate);
        }
    };

    private DSSCertificateTokenSecurityFactory() {
    }

    @Override
    protected String getFactoryClassName() {
        return CertificateFactory.class.getSimpleName();
    }
}

