/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.http.commons;

import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.StatusLine;

public class CommonsHttpClientResponseHandler
implements HttpClientResponseHandler<byte[]> {
    private static final List<Integer> ACCEPTED_HTTP_STATUS = Collections.singletonList(200);
    private List<Integer> acceptedHttpStatuses = ACCEPTED_HTTP_STATUS;

    public List<Integer> getAcceptedHttpStatuses() {
        return this.acceptedHttpStatuses;
    }

    public void setAcceptedHttpStatuses(List<Integer> acceptedHttpStatuses) {
        this.acceptedHttpStatuses = acceptedHttpStatuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] handleResponse(ClassicHttpResponse classicHttpResponse) throws IOException {
        try {
            StatusLine statusLine = new StatusLine(classicHttpResponse);
            int statusCode = statusLine.getStatusCode();
            String reasonPhrase = statusLine.getReasonPhrase();
            if (!this.acceptedHttpStatuses.contains(statusCode)) {
                String reason = Utils.isStringNotEmpty(reasonPhrase) ? " / reason : " + reasonPhrase : "";
                throw new IOException("Not acceptable HTTP Status (HTTP status code : " + statusCode + reason + ")");
            }
            HttpEntity responseEntity = classicHttpResponse.getEntity();
            if (responseEntity == null) {
                throw new IOException("No message entity for this response");
            }
            byte[] byArray = this.getContent(responseEntity);
            return byArray;
        }
        finally {
            this.closeQuietly(classicHttpResponse);
        }
    }

    protected byte[] getContent(HttpEntity responseEntity) throws IOException {
        try (InputStream content = responseEntity.getContent();){
            byte[] byArray = DSSUtils.toByteArray(content);
            return byArray;
        }
    }

    protected void closeQuietly(ClassicHttpResponse classicHttpResponse) {
        if (classicHttpResponse != null) {
            EntityUtils.consumeQuietly(classicHttpResponse.getEntity());
            Utils.closeQuietly(classicHttpResponse);
        }
    }
}

