/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.RevocationInfoArchival;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.utils.Utils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x509.CertificateList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfCmsCRLSource
extends OfflineCRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(PdfCmsCRLSource.class);

    public PdfCmsCRLSource(AttributeTable signedAttributes) {
        this.extractCRLArchivalValues(signedAttributes);
    }

    private void extractCRLArchivalValues(AttributeTable signedAttributes) {
        if (signedAttributes != null) {
            Attribute[] attributes;
            for (Attribute attribute : attributes = DSSASN1Utils.getAsn1Attributes(signedAttributes, OID.adbe_revocationInfoArchival)) {
                Object[] attributeValues = attribute.getAttributeValues();
                if (!Utils.isArrayNotEmpty(attributeValues)) continue;
                for (Object attrValue : attributeValues) {
                    this.extractRevocationInfoArchival((ASN1Encodable)attrValue);
                }
            }
        }
    }

    private void extractRevocationInfoArchival(ASN1Encodable attrValue) {
        RevocationInfoArchival revValues = PAdESUtils.getRevocationInfoArchival(attrValue);
        if (revValues != null) {
            for (CertificateList revValue : revValues.getCrlVals()) {
                try {
                    this.addBinary(CRLUtils.buildCRLBinary(revValue.getEncoded()), RevocationOrigin.ADBE_REVOCATION_INFO_ARCHIVAL);
                }
                catch (Exception e) {
                    LOG.warn("Could not convert CertificateList to CRLBinary : {}", (Object)e.getMessage());
                }
            }
        }
    }
}

