/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SigningOperation;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.PAdESTimestampParameters;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.signature.ExternalCMSService;
import eu.europa.esig.dss.pades.signature.PAdESExtensionService;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineLT;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineLTA;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineT;
import eu.europa.esig.dss.pades.timestamp.PAdESTimestampService;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.ServiceLoaderPdfObjFactory;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.tsp.TSPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESService
extends AbstractSignatureService<PAdESSignatureParameters, PAdESTimestampParameters> {
    private static final long serialVersionUID = -6518552348520127617L;
    private static final Logger LOG = LoggerFactory.getLogger(PAdESService.class);
    private final ExternalCMSService cmsForPAdESGenerationService;
    private IPdfObjFactory pdfObjFactory = new ServiceLoaderPdfObjFactory();

    public PAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        this.cmsForPAdESGenerationService = new ExternalCMSService(certificateVerifier);
        LOG.debug("+ PAdESService created");
    }

    public void setPdfObjFactory(IPdfObjFactory pdfObjFactory) {
        Objects.requireNonNull(pdfObjFactory, "PdfObjFactory is null");
        this.pdfObjFactory = pdfObjFactory;
    }

    @Override
    public void setTspSource(TSPSource tspSource) {
        super.setTspSource(tspSource);
        this.cmsForPAdESGenerationService.setTspSource(tspSource);
    }

    private SignatureExtension<PAdESSignatureParameters> getExtensionProfile(SignatureLevel signatureLevel) {
        Objects.requireNonNull(signatureLevel, "SignatureLevel must be defined!");
        switch (signatureLevel) {
            case PAdES_BASELINE_B: {
                return null;
            }
            case PAdES_BASELINE_T: {
                return new PAdESLevelBaselineT(this.tspSource, this.certificateVerifier, this.pdfObjFactory);
            }
            case PAdES_BASELINE_LT: {
                return new PAdESLevelBaselineLT(this.tspSource, this.certificateVerifier, this.pdfObjFactory);
            }
            case PAdES_BASELINE_LTA: {
                return new PAdESLevelBaselineLTA(this.tspSource, this.certificateVerifier, this.pdfObjFactory);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported signature format '%s' for extension.", new Object[]{signatureLevel}));
    }

    @Override
    public TimestampToken getContentTimestamp(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        PAdESUtils.assertPdfDocument(toSignDocument);
        this.assertContentTimestampParametersValid(parameters);
        PDFSignatureService pdfSignatureService = this.getContentTimestampService();
        DSSMessageDigest messageDigest = pdfSignatureService.messageDigest(toSignDocument, parameters);
        TimestampBinary timeStampResponse = this.tspSource.getTimeStampResponse(parameters.getDigestAlgorithm(), messageDigest.getValue());
        try {
            return new TimestampToken(timeStampResponse.getBytes(), TimestampType.CONTENT_TIMESTAMP);
        }
        catch (IOException | CMSException | TSPException e) {
            throw new DSSException("Cannot obtain the content timestamp", e);
        }
    }

    private void assertContentTimestampParametersValid(PAdESSignatureParameters parameters) {
        if (parameters.getDigestAlgorithm() != parameters.getContentTimestampParameters().getDigestAlgorithm()) {
            throw new UnsupportedOperationException("DigestAlgorithm for content timestamp creation shall be the same as the one defined in PAdESSignatureParameters!");
        }
    }

    public DSSDocument previewPageWithVisualSignature(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        PAdESUtils.assertPdfDocument(toSignDocument);
        PDFSignatureService pdfSignatureService = this.getPAdESSignatureService();
        return pdfSignatureService.previewPageWithVisualSignature(toSignDocument, parameters);
    }

    public DSSDocument previewSignatureField(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        PAdESUtils.assertPdfDocument(toSignDocument);
        PDFSignatureService pdfSignatureService = this.getPAdESSignatureService();
        return pdfSignatureService.previewSignatureField(toSignDocument, parameters);
    }

    @Override
    public ToBeSigned getDataToSign(DSSDocument toSignDocument, PAdESSignatureParameters parameters) throws DSSException {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        PAdESUtils.assertPdfDocument(toSignDocument);
        this.assertSigningCertificateValid(parameters);
        DSSMessageDigest messageDigest = this.computeDocumentDigest(toSignDocument, parameters);
        return this.cmsForPAdESGenerationService.buildToBeSignedData(messageDigest, parameters);
    }

    protected DSSMessageDigest computeDocumentDigest(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        PDFSignatureService pdfSignatureService = this.getPAdESSignatureService();
        return pdfSignatureService.messageDigest(toSignDocument, parameters);
    }

    @Override
    public DSSDocument signDocument(DSSDocument toSignDocument, PAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        PAdESUtils.assertPdfDocument(toSignDocument);
        this.assertSigningCertificateValid(parameters);
        signatureValue = this.ensureSignatureValue(parameters.getSignatureAlgorithm(), signatureValue);
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        byte[] cmsSignedData = this.generateCMSSignedData(toSignDocument, parameters, signatureValue);
        PDFSignatureService pdfSignatureService = this.getPAdESSignatureService();
        DSSDocument signature = pdfSignatureService.sign(toSignDocument, cmsSignedData, parameters);
        SignatureExtension<PAdESSignatureParameters> extension = this.getExtensionProfile(signatureLevel);
        if (signatureLevel != SignatureLevel.PAdES_BASELINE_B && signatureLevel != SignatureLevel.PAdES_BASELINE_T && extension != null) {
            signature = extension.extendSignatures(signature, parameters);
        }
        parameters.reinit();
        signature.setName(this.getFinalFileName(toSignDocument, SigningOperation.SIGN, parameters.getSignatureLevel()));
        return signature;
    }

    protected byte[] generateCMSSignedData(DSSDocument toSignDocument, PAdESSignatureParameters parameters, SignatureValue signatureValue) {
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        Objects.requireNonNull(signatureAlgorithm, "SignatureAlgorithm cannot be null!");
        Objects.requireNonNull(signatureLevel, "SignatureLevel must be defined!");
        DSSMessageDigest messageDigest = this.computeDocumentDigest(toSignDocument, parameters);
        CMS cms = this.cmsForPAdESGenerationService.buildCMS(messageDigest, parameters, signatureValue);
        return cms.getDEREncoded();
    }

    @Override
    public DSSDocument extendDocument(DSSDocument toExtendDocument, PAdESSignatureParameters parameters) throws DSSException {
        Objects.requireNonNull(toExtendDocument, "toExtendDocument is not defined!");
        Objects.requireNonNull(parameters, "Cannot extend the signature. SignatureParameters are not defined!");
        PAdESUtils.assertPdfDocument(toExtendDocument);
        this.assertExtensionParametersValid(parameters);
        SignatureExtension<PAdESSignatureParameters> extension = this.getExtensionProfile(parameters.getSignatureLevel());
        if (extension != null) {
            DSSDocument extended = extension.extendSignatures(toExtendDocument, parameters);
            extended.setName(this.getFinalFileName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel()));
            return extended;
        }
        return toExtendDocument;
    }

    private void assertExtensionParametersValid(PAdESSignatureParameters parameters) {
        if (SignatureLevel.PAdES_BASELINE_B.equals((Object)parameters.getSignatureLevel())) {
            throw new UnsupportedOperationException(String.format("Unsupported signature format '%s' for extension.", new Object[]{parameters.getSignatureLevel()}));
        }
    }

    public List<String> getAvailableSignatureFields(DSSDocument document) {
        return this.getAvailableSignatureFields(document, null);
    }

    public List<String> getAvailableSignatureFields(DSSDocument document, char[] passwordProtection) {
        Objects.requireNonNull(document, "DSSDocument is not defined!");
        PAdESUtils.assertPdfDocument(document);
        PDFSignatureService pdfSignatureService = this.getPAdESSignatureService();
        return pdfSignatureService.getAvailableSignatureFields(document, passwordProtection);
    }

    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters) {
        return this.addNewSignatureField(document, parameters, null);
    }

    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters, char[] passwordProtection) {
        Objects.requireNonNull(document, "DSSDocument is not defined!");
        Objects.requireNonNull(parameters, "SignatureFieldParameters cannot be null!");
        PAdESUtils.assertPdfDocument(document);
        PDFSignatureService pdfSignatureService = this.getPAdESSignatureService();
        return pdfSignatureService.addNewSignatureField(document, parameters, passwordProtection);
    }

    @Override
    public DSSDocument timestamp(DSSDocument toTimestampDocument, PAdESTimestampParameters parameters) {
        Objects.requireNonNull(toTimestampDocument, "Document to be timestamped is not defined!");
        Objects.requireNonNull(parameters, "PAdESTimestampParameters cannot be null!");
        PAdESUtils.assertPdfDocument(toTimestampDocument);
        PAdESExtensionService extensionService = new PAdESExtensionService(this.certificateVerifier, this.pdfObjFactory);
        DSSDocument extendedDocument = extensionService.incorporateValidationData(toTimestampDocument, parameters.getPasswordProtection());
        PAdESTimestampService timestampService = new PAdESTimestampService(this.tspSource, this.getSignatureTimestampService());
        DSSDocument timestampedDocument = timestampService.timestampDocument(extendedDocument, parameters);
        timestampedDocument.setName(this.getFinalFileName(toTimestampDocument, SigningOperation.TIMESTAMP, null));
        return timestampedDocument;
    }

    protected PDFSignatureService getPAdESSignatureService() {
        return this.pdfObjFactory.newPAdESSignatureService();
    }

    protected PDFSignatureService getContentTimestampService() {
        return this.pdfObjFactory.newContentTimestampService();
    }

    protected PDFSignatureService getSignatureTimestampService() {
        return this.pdfObjFactory.newSignatureTimestampService();
    }
}

