/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.policy.crypto;

import eu.europa.esig.dss.enumerations.CryptographicSuiteAlgorithmUsage;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuite19322;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteAlgorithm;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteEvaluation;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CryptographicSuiteCatalogue {
    private final Map<List<CryptographicSuiteAlgorithm>, CryptographicSuite> cryptographicSuiteMap = new HashMap<List<CryptographicSuiteAlgorithm>, CryptographicSuite>();
    private CryptographicSuiteMetadata metadata;
    private List<CryptographicSuiteAlgorithm> algorithmList;

    protected CryptographicSuiteCatalogue() {
    }

    protected CryptographicSuiteMetadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = this.buildMetadata();
        }
        return this.metadata;
    }

    protected abstract CryptographicSuiteMetadata buildMetadata();

    protected List<CryptographicSuiteAlgorithm> getAlgorithmList() {
        if (this.algorithmList == null) {
            this.algorithmList = this.buildAlgorithmList();
        }
        return this.algorithmList;
    }

    protected abstract List<CryptographicSuiteAlgorithm> buildAlgorithmList();

    public CryptographicSuite getCryptographicSuite() {
        List<CryptographicSuiteAlgorithm> algorithms = this.filterByAlgorithmUsage(this.getAlgorithmList(), Arrays.asList(CryptographicSuiteAlgorithmUsage.SIGN_DATA, CryptographicSuiteAlgorithmUsage.VALIDATE_DATA));
        return this.getCryptographicSuite(this.getMetadata(), algorithms);
    }

    public CryptographicSuite getSignatureCryptographicSuite() {
        return this.getCryptographicSuite();
    }

    public CryptographicSuite getSignatureCertificatesCryptographicSuite() {
        List<CryptographicSuiteAlgorithm> algorithms = this.filterByAlgorithmUsage(this.getAlgorithmList(), Arrays.asList(CryptographicSuiteAlgorithmUsage.SIGN_DATA, CryptographicSuiteAlgorithmUsage.VALIDATE_DATA, CryptographicSuiteAlgorithmUsage.SIGN_CERTIFICATES, CryptographicSuiteAlgorithmUsage.VALIDATE_CERTIFICATES));
        return this.getCryptographicSuite(this.getMetadata(), algorithms);
    }

    public CryptographicSuite getCounterSignatureCryptographicSuite() {
        return this.getCryptographicSuite();
    }

    public CryptographicSuite getCounterSignatureCertificatesCryptographicSuite() {
        return this.getSignatureCertificatesCryptographicSuite();
    }

    public CryptographicSuite getRevocationCryptographicSuite() {
        List<CryptographicSuiteAlgorithm> algorithms = this.filterByAlgorithmUsage(this.getAlgorithmList(), Arrays.asList(CryptographicSuiteAlgorithmUsage.SIGN_DATA, CryptographicSuiteAlgorithmUsage.VALIDATE_DATA, CryptographicSuiteAlgorithmUsage.SIGN_OCSP, CryptographicSuiteAlgorithmUsage.VALIDATE_OCSP));
        return this.getCryptographicSuite(this.getMetadata(), algorithms);
    }

    public CryptographicSuite getRevocationCertificatesCryptographicSuite() {
        List<CryptographicSuiteAlgorithm> algorithms = this.filterByAlgorithmUsage(this.getAlgorithmList(), Arrays.asList(CryptographicSuiteAlgorithmUsage.SIGN_DATA, CryptographicSuiteAlgorithmUsage.VALIDATE_DATA, CryptographicSuiteAlgorithmUsage.SIGN_OCSP, CryptographicSuiteAlgorithmUsage.VALIDATE_OCSP, CryptographicSuiteAlgorithmUsage.SIGN_CERTIFICATES, CryptographicSuiteAlgorithmUsage.VALIDATE_CERTIFICATES));
        return this.getCryptographicSuite(this.getMetadata(), algorithms);
    }

    public CryptographicSuite getTimestampCryptographicSuite() {
        List<CryptographicSuiteAlgorithm> algorithms = this.filterByAlgorithmUsage(this.getAlgorithmList(), Arrays.asList(CryptographicSuiteAlgorithmUsage.SIGN_DATA, CryptographicSuiteAlgorithmUsage.VALIDATE_DATA, CryptographicSuiteAlgorithmUsage.SIGN_TIMESTAMPS, CryptographicSuiteAlgorithmUsage.VALIDATE_TIMESTAMPS));
        return this.getCryptographicSuite(this.getMetadata(), algorithms);
    }

    public CryptographicSuite getTimestampCertificatesCryptographicSuite() {
        List<CryptographicSuiteAlgorithm> algorithms = this.filterByAlgorithmUsage(this.getAlgorithmList(), Arrays.asList(CryptographicSuiteAlgorithmUsage.SIGN_DATA, CryptographicSuiteAlgorithmUsage.VALIDATE_DATA, CryptographicSuiteAlgorithmUsage.SIGN_TIMESTAMPS, CryptographicSuiteAlgorithmUsage.VALIDATE_TIMESTAMPS, CryptographicSuiteAlgorithmUsage.SIGN_CERTIFICATES, CryptographicSuiteAlgorithmUsage.VALIDATE_CERTIFICATES));
        return this.getCryptographicSuite(this.getMetadata(), algorithms);
    }

    public CryptographicSuite getEvidenceRecordSignatureCryptographicSuite() {
        return this.getCryptographicSuite();
    }

    private List<CryptographicSuiteAlgorithm> filterByAlgorithmUsage(List<CryptographicSuiteAlgorithm> algorithmList, List<CryptographicSuiteAlgorithmUsage> algorithmUsages) {
        ArrayList<CryptographicSuiteAlgorithm> result = new ArrayList<CryptographicSuiteAlgorithm>();
        for (CryptographicSuiteAlgorithm algorithm : algorithmList) {
            if ((algorithm = CryptographicSuiteAlgorithm.copy(algorithm)).getEvaluationList() == null || algorithm.getEvaluationList().isEmpty()) {
                result.add(algorithm);
                continue;
            }
            ArrayList<CryptographicSuiteEvaluation> evaluationList = new ArrayList<CryptographicSuiteEvaluation>();
            for (CryptographicSuiteEvaluation evaluation : algorithm.getEvaluationList()) {
                List<CryptographicSuiteAlgorithmUsage> algorithmUsage = evaluation.getAlgorithmUsage();
                if (algorithmUsage != null && !algorithmUsage.isEmpty()) {
                    if (!algorithmUsage.stream().anyMatch(algorithmUsages::contains)) continue;
                }
                evaluationList.add(evaluation);
            }
            algorithm.setEvaluationList(evaluationList);
            if (evaluationList.isEmpty()) continue;
            result.add(algorithm);
        }
        return result;
    }

    protected CryptographicSuite getCryptographicSuite(CryptographicSuiteMetadata metadata, List<CryptographicSuiteAlgorithm> algorithmList) {
        CryptographicSuite cryptographicSuite = this.cryptographicSuiteMap.get(algorithmList);
        if (cryptographicSuite == null) {
            cryptographicSuite = new CryptographicSuite19322(metadata, algorithmList);
            this.cryptographicSuiteMap.put(algorithmList, cryptographicSuite);
        }
        return cryptographicSuite;
    }
}

