/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;

public class JWS
extends JsonWebSignature
implements Serializable {
    private static final long serialVersionUID = -3465226120689258742L;
    private Map<String, Object> unprotected;
    private JWSJsonSerializationObject jwsJsonSerializationObject;

    public JWS() {
    }

    public JWS(String[] parts) {
        Objects.requireNonNull(parts, "Parts part cannot be null");
        try {
            this.setCompactSerializationParts(parts);
        }
        catch (JoseException e) {
            throw new IllegalInputException("Unable to instantiate a compact JWS", e);
        }
    }

    @Override
    public String getEncodedHeader() {
        return super.getEncodedHeader();
    }

    public void setPayloadOctets(byte[] payload) {
        if (this.isRfc7797UnencodedPayload()) {
            this.setPayloadBytes(payload);
        } else {
            this.setEncodedPayload(new String(payload));
        }
    }

    public String getSignedPayload() {
        if (this.isRfc7797UnencodedPayload()) {
            return this.getUnverifiedPayload();
        }
        return this.getEncodedPayload();
    }

    @Override
    public boolean isRfc7797UnencodedPayload() {
        return super.isRfc7797UnencodedPayload();
    }

    public byte[] getSignatureValue() {
        return super.getSignature();
    }

    @Override
    public void setSignature(byte[] signature) {
        super.setSignature(signature);
    }

    public void setProtected(String protectedBase64Url) throws JoseException {
        super.setEncodedHeader(protectedBase64Url);
    }

    public Map<String, Object> getUnprotected() {
        return this.unprotected;
    }

    public void setUnprotected(Map<String, Object> unprotected) {
        this.unprotected = unprotected;
    }

    public JWSJsonSerializationObject getJwsJsonSerializationObject() {
        return this.jwsJsonSerializationObject;
    }

    public void setJwsJsonSerializationObject(JWSJsonSerializationObject jwsJsonSerializationObject) {
        this.jwsJsonSerializationObject = jwsJsonSerializationObject;
    }

    public JWSSerializationType getJwsSerializationType() {
        if (this.jwsJsonSerializationObject != null) {
            return this.jwsJsonSerializationObject.getJWSSerializationType();
        }
        return JWSSerializationType.COMPACT_SERIALIZATION;
    }

    public void setKnownCriticalHeaders(Collection<String> knownCriticalHeaders) {
        String[] headersArray = knownCriticalHeaders.toArray(new String[knownCriticalHeaders.size()]);
        super.setKnownCriticalHeaders(headersArray);
    }

    @Override
    protected void checkCrit() throws JoseException {
    }

    public String getProtectedHeaderValueAsString(String key) {
        return DSSJsonUtils.toString(this.getHeaders().getObjectHeaderValue(key), key);
    }

    public Number getProtectedHeaderValueAsNumber(String key) {
        return DSSJsonUtils.toNumber(this.getHeaders().getObjectHeaderValue(key), key);
    }

    public Map<?, ?> getProtectedHeaderValueAsMap(String key) {
        return DSSJsonUtils.toMap(this.getHeaders().getObjectHeaderValue(key), key);
    }

    public List<?> getProtectedHeaderValueAsList(String key) {
        return DSSJsonUtils.toList(this.getHeaders().getObjectHeaderValue(key), key);
    }
}

