/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.i18n;

import eu.europa.esig.dss.i18n.MessageTag;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nProvider {
    private static final Logger LOG = LoggerFactory.getLogger(I18nProvider.class);
    private static final String MESSAGES = "dss-messages";
    private final ResourceBundle bundle;
    private final Set<String> keySet;

    public I18nProvider() {
        this(Locale.getDefault());
    }

    public I18nProvider(Locale locale) {
        this.bundle = ResourceBundle.getBundle(MESSAGES, locale);
        this.keySet = this.bundle.keySet();
    }

    public String getMessage(MessageTag messageTag, Object ... args2) {
        if (messageTag == null) {
            throw new IllegalArgumentException("messageTag cannot be null!");
        }
        if (this.keySet.contains(messageTag.getId())) {
            String patternString = this.bundle.getString(messageTag.getId());
            return MessageFormat.format(patternString, this.getArgs(args2));
        }
        LOG.warn("A value for the MessageTag [{}] not defined!", (Object)messageTag.getId());
        return messageTag.getId();
    }

    private Object[] getArgs(Object[] args2) {
        Object[] translated = null;
        if (args2 != null) {
            translated = (Object[])args2.clone();
            for (int i = 0; i < args2.length; ++i) {
                if (!(args2[i] instanceof MessageTag)) continue;
                translated[i] = this.getMessage((MessageTag)((Object)args2[i]), new Object[0]);
            }
        }
        return translated;
    }
}

