/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.validation;

import eu.europa.esig.dss.enumerations.EvidenceRecordTypeEnum;
import eu.europa.esig.dss.evidencerecord.common.validation.DefaultEvidenceRecordAnalyzer;
import eu.europa.esig.dss.evidencerecord.common.validation.EvidenceRecordValidatorFactory;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.evidencerecord.EvidenceRecordValidator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;

public abstract class DefaultEvidenceRecordValidator
extends SignedDocumentValidator
implements EvidenceRecordValidator {
    protected DefaultEvidenceRecordValidator(DefaultEvidenceRecordAnalyzer evidenceRecordAnalyzer) {
        super(evidenceRecordAnalyzer);
    }

    @Override
    public DefaultEvidenceRecordAnalyzer getDocumentAnalyzer() {
        return (DefaultEvidenceRecordAnalyzer)super.getDocumentAnalyzer();
    }

    public static DefaultEvidenceRecordValidator fromDocument(DSSDocument dssDocument) {
        Objects.requireNonNull(dssDocument, "DSSDocument is null");
        ServiceLoader<EvidenceRecordValidatorFactory> serviceLoaders = ServiceLoader.load(EvidenceRecordValidatorFactory.class);
        for (EvidenceRecordValidatorFactory factory : serviceLoaders) {
            if (!factory.isSupported(dssDocument)) continue;
            return factory.create(dssDocument);
        }
        throw new UnsupportedOperationException("Document format not recognized/handled");
    }

    @Override
    public EvidenceRecord getEvidenceRecord() {
        return this.getDocumentAnalyzer().getEvidenceRecord();
    }

    @Override
    public EvidenceRecordTypeEnum getEvidenceRecordType() {
        return this.getDocumentAnalyzer().getEvidenceRecordType();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        throw new UnsupportedOperationException("getOriginalDocuments(AdvancedSignature) is not supported for EvidenceRecordValidator!");
    }
}

