/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.validation;

import eu.europa.esig.dss.enumerations.EvidenceRecordIncorporationType;
import eu.europa.esig.dss.enumerations.EvidenceRecordOrigin;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.analyzer.DefaultDocumentAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzerFactory;
import eu.europa.esig.dss.spi.validation.evidencerecord.EmbeddedEvidenceRecordHelper;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class DefaultEvidenceRecordAnalyzer
extends DefaultDocumentAnalyzer
implements EvidenceRecordAnalyzer {
    private EvidenceRecord evidenceRecord;
    protected EvidenceRecordOrigin evidenceRecordOrigin = EvidenceRecordOrigin.EXTERNAL;
    protected EvidenceRecordIncorporationType evidenceRecordIncorporationType;
    protected EmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper;

    protected DefaultEvidenceRecordAnalyzer() {
    }

    protected DefaultEvidenceRecordAnalyzer(DSSDocument document) {
        Objects.requireNonNull(document, "Document to be validated cannot be null!");
        this.document = document;
    }

    public static EvidenceRecordAnalyzer fromDocument(DSSDocument dssDocument) {
        return EvidenceRecordAnalyzerFactory.fromDocument(dssDocument);
    }

    @Override
    public EvidenceRecord getEvidenceRecord() {
        if (this.evidenceRecord == null) {
            this.evidenceRecord = this.buildEvidenceRecord();
            List<SignatureScope> evidenceRecordScopes = this.getEvidenceRecordScopes(this.evidenceRecord);
            this.evidenceRecord.setEvidenceRecordScopes(evidenceRecordScopes);
            this.evidenceRecord.setTimestampedReferences(this.getTimestampedReferences(evidenceRecordScopes));
        }
        return this.evidenceRecord;
    }

    @Override
    public void setEvidenceRecordOrigin(EvidenceRecordOrigin origin) {
        this.evidenceRecordOrigin = origin;
    }

    @Override
    public void setEvidenceRecordIncorporationType(EvidenceRecordIncorporationType evidenceRecordIncorporationType) {
        this.evidenceRecordIncorporationType = evidenceRecordIncorporationType;
    }

    @Override
    public void setEmbeddedEvidenceRecordHelper(EmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper) {
        this.embeddedEvidenceRecordHelper = embeddedEvidenceRecordHelper;
    }

    protected List<DSSDocument> getEvidenceRecordDetachedContents() {
        if (this.embeddedEvidenceRecordHelper != null && Utils.isCollectionNotEmpty(this.embeddedEvidenceRecordHelper.getDetachedContents())) {
            return this.embeddedEvidenceRecordHelper.getDetachedContents();
        }
        return this.detachedContents;
    }

    protected abstract EvidenceRecord buildEvidenceRecord();

    @Override
    public List<EvidenceRecord> getDetachedEvidenceRecords() {
        return Collections.singletonList(this.getEvidenceRecord());
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        throw new UnsupportedOperationException("getOriginalDocuments(AdvancedSignature) is not supported for EvidenceRecordValidator!");
    }
}

