/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.asn1.validation;

import eu.europa.esig.dss.enumerations.EvidenceRecordTypeEnum;
import eu.europa.esig.dss.evidencerecord.asn1.validation.ASN1EvidenceRecord;
import eu.europa.esig.dss.evidencerecord.common.validation.DefaultEvidenceRecordAnalyzer;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import org.bouncycastle.asn1.tsp.EvidenceRecord;

public class ASN1EvidenceRecordAnalyzer
extends DefaultEvidenceRecordAnalyzer {
    private EvidenceRecord evidenceRecordObject;

    public ASN1EvidenceRecordAnalyzer(DSSDocument document) {
        super(document);
        this.evidenceRecordObject = this.toASN1Document(document);
    }

    ASN1EvidenceRecordAnalyzer() {
    }

    private EvidenceRecord toASN1Document(DSSDocument document) {
        try {
            return EvidenceRecord.getInstance(DSSUtils.toByteArray(document));
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("An ASN.1 file is expected : %s", e.getMessage()), e);
        }
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        byte firstByte = DSSUtils.readFirstByte(dssDocument);
        return DSSASN1Utils.isASN1SequenceTag(firstByte) && this.canBuildEvidenceRecord(dssDocument);
    }

    private boolean canBuildEvidenceRecord(DSSDocument dssDocument) {
        try {
            this.toASN1Document(dssDocument);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord buildEvidenceRecord() {
        ASN1EvidenceRecord evidenceRecord = new ASN1EvidenceRecord(this.evidenceRecordObject);
        evidenceRecord.setFilename(this.document.getName());
        evidenceRecord.setOrigin(this.evidenceRecordOrigin);
        evidenceRecord.setIncorporationType(this.evidenceRecordIncorporationType);
        evidenceRecord.setManifestFile(this.manifestFile);
        evidenceRecord.setDetachedContents(this.getEvidenceRecordDetachedContents());
        evidenceRecord.setEmbeddedEvidenceRecordHelper(this.embeddedEvidenceRecordHelper);
        return evidenceRecord;
    }

    @Override
    public EvidenceRecordTypeEnum getEvidenceRecordType() {
        return EvidenceRecordTypeEnum.ASN1_EVIDENCE_RECORD;
    }
}

