/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.asn1.digest;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.evidencerecord.asn1.digest.ASN1ArchiveTimeStampSequenceDigestHelper;
import eu.europa.esig.dss.evidencerecord.asn1.validation.ASN1EvidenceRecord;
import eu.europa.esig.dss.evidencerecord.common.digest.AbstractEvidenceRecordRenewalDigestBuilder;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASN1EvidenceRecordRenewalDigestBuilder
extends AbstractEvidenceRecordRenewalDigestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ASN1EvidenceRecordRenewalDigestBuilder.class);

    public ASN1EvidenceRecordRenewalDigestBuilder(DSSDocument document) {
        this(new ASN1EvidenceRecord(document));
    }

    public ASN1EvidenceRecordRenewalDigestBuilder(DSSDocument document, DigestAlgorithm digestAlgorithm) {
        this(new ASN1EvidenceRecord(document), digestAlgorithm);
    }

    public ASN1EvidenceRecordRenewalDigestBuilder(ASN1EvidenceRecord asn1EvidenceRecord) {
        super(asn1EvidenceRecord);
    }

    public ASN1EvidenceRecordRenewalDigestBuilder(ASN1EvidenceRecord asn1EvidenceRecord, DigestAlgorithm digestAlgorithm) {
        super(asn1EvidenceRecord, digestAlgorithm);
    }

    @Override
    public ASN1EvidenceRecordRenewalDigestBuilder setDetachedContent(List<DSSDocument> detachedContent) {
        return (ASN1EvidenceRecordRenewalDigestBuilder)super.setDetachedContent(detachedContent);
    }

    @Override
    public DSSMessageDigest buildTimeStampRenewalDigest() {
        ArchiveTimeStampObject archiveTimeStampObject = this.getLastArchiveTimeStampObject();
        return this.getArchiveTimeStampSequenceDigestHelper().buildTimeStampRenewalDigest(archiveTimeStampObject);
    }

    @Override
    public List<Digest> buildHashTreeRenewalDigestGroup() {
        ArrayList<Digest> result = new ArrayList<Digest>();
        if (Utils.isCollectionNotEmpty(this.detachedContent)) {
            DigestAlgorithm digestAlgorithm = this.getDigestAlgorithmOrDefault();
            ArchiveTimeStampChainObject lastArchiveTimeStampChainObject = this.getLastArchiveTimeStampChainObject();
            DSSMessageDigest lastTimeStampSequenceHash = this.getArchiveTimeStampSequenceDigestHelper().buildArchiveTimeStampSequenceDigest(digestAlgorithm, lastArchiveTimeStampChainObject.getOrder() + 1);
            for (DSSDocument document : this.detachedContent) {
                DSSMessageDigest chainAndDocumentHash = this.getArchiveTimeStampSequenceDigestHelper().computeChainAndDocumentHash((Digest)lastTimeStampSequenceHash, document);
                result.add(new DSSMessageDigest(digestAlgorithm, chainAndDocumentHash.getValue()));
            }
        } else {
            LOG.warn("No detached content have been provided! Computation of digest for hash-tree renewal is skipped.");
        }
        return result;
    }

    protected ASN1ArchiveTimeStampSequenceDigestHelper getArchiveTimeStampSequenceDigestHelper() {
        return new ASN1ArchiveTimeStampSequenceDigestHelper((ASN1EvidenceRecord)this.evidenceRecord);
    }
}

