/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureParameters;
import eu.europa.esig.dss.cades.signature.CMSForCAdESBuilderHelper;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentAnalyzer;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSBuilder;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.cms.operator.CustomContentSigner;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.BaselineBCertificateSelector;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.ContentSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESCounterSignatureBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESCounterSignatureBuilder.class);
    private final CertificateVerifier certificateVerifier;
    private ManifestFile manifestFile;
    protected DSSResourcesHandlerBuilder resourcesHandlerBuilder;

    public CAdESCounterSignatureBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public void setManifestFile(ManifestFile manifestFile) {
        this.manifestFile = manifestFile;
    }

    public void setResourcesHandlerBuilder(DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        this.resourcesHandlerBuilder = resourcesHandlerBuilder;
    }

    public DSSDocument addCounterSignature(CMS originalCMS, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        List<SignerInformation> updatedSignerInfo = this.getUpdatedSignerInformations(originalCMS, originalCMS.getSignerInfos(), parameters, signatureValue, null);
        CMS updatedCMS = CMSUtils.replaceSigners(originalCMS, new SignerInformationStore(updatedSignerInfo));
        updatedCMS = CMSUtils.populateDigestAlgorithmSet(updatedCMS, originalCMS.getDigestAlgorithmIDs());
        updatedCMS = this.addNewCertificates(updatedCMS, parameters);
        return CMSUtils.writeToDSSDocument(updatedCMS, this.resourcesHandlerBuilder);
    }

    private List<SignerInformation> getUpdatedSignerInformations(CMS originalCMS, SignerInformationStore signerInformationStore, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue, CAdESSignature masterSignature) {
        LinkedList<SignerInformation> result = new LinkedList<SignerInformation>();
        for (SignerInformation signerInformation : signerInformationStore) {
            CAdESSignature cades = new CAdESSignature(originalCMS, signerInformation);
            cades.setMasterSignature(masterSignature);
            cades.setDetachedContents(parameters.getDetachedContents());
            cades.setManifestFile(this.manifestFile);
            if (Utils.areStringsEqual(cades.getId(), parameters.getSignatureIdToCounterSign())) {
                if (masterSignature != null) {
                    throw new UnsupportedOperationException("Cannot recursively add a counter-signature");
                }
                this.assertCounterSignaturePossible(signerInformation);
                SignerInformationStore counterSignatureSignerInfoStore = this.generateCounterSignature(signerInformation, parameters, signatureValue);
                result.add(SignerInformation.addCounterSigners(signerInformation, counterSignatureSignerInfoStore));
                continue;
            }
            if (signerInformation.getCounterSignatures().size() > 0) {
                List<SignerInformation> updatedCounterSigners = this.getUpdatedSignerInformations(originalCMS, signerInformation.getCounterSignatures(), parameters, signatureValue, cades);
                result.add(this.replaceCounterSigners(signerInformation, updatedCounterSigners));
                continue;
            }
            result.add(signerInformation);
        }
        return result;
    }

    private SignerInformation replaceCounterSigners(SignerInformation signerInformation, List<SignerInformation> updatedCounterSigners) {
        ASN1EncodableVector attrs = new ASN1EncodableVector();
        Attribute counterSignatureAttribute = this.getUpdatedCounterSignatureAttribute(updatedCounterSigners);
        AttributeTable currentUnsignedAttributes = signerInformation.getUnsignedAttributes();
        ASN1EncodableVector currentASN1EncodableVector = currentUnsignedAttributes.toASN1EncodableVector();
        for (int i = 0; i < currentASN1EncodableVector.size(); ++i) {
            ASN1Encodable asn1Encodable = currentASN1EncodableVector.get(i);
            if (this.isCounterSignatureAttribute(asn1Encodable)) {
                attrs.add(counterSignatureAttribute);
                continue;
            }
            attrs.add(asn1Encodable);
        }
        return CMSUtils.replaceUnsignedAttributes(signerInformation, new AttributeTable(attrs));
    }

    private boolean isCounterSignatureAttribute(ASN1Encodable asn1Encodable) {
        try {
            Attribute attribute = Attribute.getInstance(asn1Encodable);
            return CMSAttributes.counterSignature.equals(attribute.getAttrType());
        }
        catch (Exception e) {
            String errorMessage = "Unable to instantiate Attribute. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
            } else {
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
            return false;
        }
    }

    private Attribute getUpdatedCounterSignatureAttribute(List<SignerInformation> updatedCounterSigners) {
        ASN1EncodableVector signers = new ASN1EncodableVector();
        for (SignerInformation counterSigner : updatedCounterSigners) {
            signers.add(counterSigner.toASN1Structure());
        }
        return new Attribute(CMSAttributes.counterSignature, new DERSet(signers));
    }

    private CMS addNewCertificates(CMS updatedCMS, CAdESCounterSignatureParameters parameters) {
        List<CertificateToken> newCertificates = new BaselineBCertificateSelector(parameters.getSigningCertificate(), parameters.getCertificateChain()).setTrustedCertificateSource(this.certificateVerifier.getTrustedCertSources()).setTrustAnchorBPPolicy(parameters.bLevel().isTrustAnchorBPPolicy()).getCertificates();
        CMSBuilder cmsBuilder = new CMSBuilder().setOriginalCMS(updatedCMS);
        return cmsBuilder.extendCMSSignedData(newCertificates, Collections.emptyList(), Collections.emptyList());
    }

    private SignerInformationStore generateCounterSignature(SignerInformation signerInformation, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId(), signatureValue.getValue());
        return this.generateCounterSignature(signerInformation, (CAdESSignatureParameters)parameters, customContentSigner);
    }

    public SignerInformationStore generateCounterSignature(SignerInformation signerInformation, CAdESSignatureParameters parameters, CustomContentSigner customContentSigner) {
        InMemoryDocument toSignDocument = new InMemoryDocument(signerInformation.getSignature());
        CMSForCAdESBuilderHelper cmsBuilderHelper = this.initCMSBuilderHelper(toSignDocument, parameters, customContentSigner);
        SignerInfoGenerator signerInfoGenerator = cmsBuilderHelper.createSignerInfoGenerator();
        try {
            CMSSignedDataGenerator cmsSignedDataGenerator = new CMSSignedDataGenerator();
            cmsSignedDataGenerator.addSignerInfoGenerator(signerInfoGenerator);
            return cmsSignedDataGenerator.generateCounterSigners(signerInformation);
        }
        catch (CMSException e) {
            throw new DSSException(String.format("Unable to generate counter-signature: %s", e.getMessage()), e);
        }
    }

    public SignerInformation getSignerInformationToBeCounterSigned(DSSDocument signatureDocument, CAdESCounterSignatureParameters parameters) {
        CAdESSignature cadesSignature = this.getSignatureById(signatureDocument, parameters);
        if (cadesSignature == null) {
            throw new IllegalArgumentException(String.format("CAdESSignature not found with the given dss id '%s'", parameters.getSignatureIdToCounterSign()));
        }
        return cadesSignature.getSignerInformation();
    }

    private CAdESSignature getSignatureById(DSSDocument signatureDocument, CAdESCounterSignatureParameters parameters) {
        Objects.requireNonNull(parameters.getSignatureIdToCounterSign(), "The Id of a signature to be counter signed shall be defined! Please use SerializableCounterSignatureParameters.setSignatureIdToCounterSign(signatureId) method.");
        CMSDocumentAnalyzer validator = new CMSDocumentAnalyzer(signatureDocument);
        validator.setDetachedContents(parameters.getDetachedContents());
        validator.setManifestFile(this.manifestFile);
        List<AdvancedSignature> signatures = validator.getSignatures();
        return this.findSignatureRecursive(signatures, parameters.getSignatureIdToCounterSign());
    }

    private CAdESSignature findSignatureRecursive(List<AdvancedSignature> signatures, String signatureId) {
        if (Utils.isCollectionNotEmpty(signatures)) {
            for (AdvancedSignature advancedSignature : signatures) {
                if (signatureId.equals(advancedSignature.getId())) {
                    CAdESSignature cades = (CAdESSignature)advancedSignature;
                    this.assertCounterSignaturePossible(cades.getSignerInformation());
                    return cades;
                }
                CAdESSignature counterSignatureById = this.findSignatureRecursive(advancedSignature.getCounterSignatures(), signatureId);
                if (counterSignatureById == null) continue;
                throw new UnsupportedOperationException("Nested counter signatures are not supported with CAdES!");
            }
        }
        return null;
    }

    private void assertCounterSignaturePossible(SignerInformation signerInformation) {
        if (CAdESUtils.containsATSTv2(signerInformation)) {
            throw new IllegalInputException("Cannot add a counter signature to a CAdES containing an archiveTimestampV2");
        }
        if (CAdESUtils.containsEvidenceRecord(signerInformation)) {
            throw new IllegalInputException("Cannot add a counter signature to a CMS containing an evidence record unsigned attribute.");
        }
    }

    protected CMSForCAdESBuilderHelper initCMSBuilderHelper(DSSDocument contentToSign, CAdESSignatureParameters signatureParameters, ContentSigner contentSigner) {
        return new CMSForCAdESBuilderHelper(contentToSign, signatureParameters, contentSigner).setTrustedCertificateSource(this.certificateVerifier.getTrustedCertSources());
    }
}

