/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.evidencerecord;

import eu.europa.esig.dss.asic.common.evidencerecord.ASiCContentDocumentFilter;
import eu.europa.esig.dss.utils.Utils;
import java.util.Arrays;

public class ASiCContentDocumentFilterFactory {
    private ASiCContentDocumentFilterFactory() {
    }

    public static ASiCContentDocumentFilter emptyFilter() {
        return new ASiCContentDocumentFilter();
    }

    public static ASiCContentDocumentFilter signedDocumentsOnlyFilter(String ... excludedFilenames) {
        ASiCContentDocumentFilter asicContentDocumentFilter = new ASiCContentDocumentFilter();
        asicContentDocumentFilter.setSignedDocuments(true);
        if (Utils.isArrayNotEmpty(excludedFilenames)) {
            asicContentDocumentFilter.setExcludedFilenames(Arrays.asList(excludedFilenames));
        }
        return asicContentDocumentFilter;
    }

    public static ASiCContentDocumentFilter archiveDocumentsFilter(String ... excludedFilenames) {
        ASiCContentDocumentFilter asicContentDocumentFilter = new ASiCContentDocumentFilter();
        asicContentDocumentFilter.setSignedDocuments(true);
        asicContentDocumentFilter.setSignatureDocuments(true);
        asicContentDocumentFilter.setTimestampDocuments(true);
        asicContentDocumentFilter.setManifestDocuments(true);
        asicContentDocumentFilter.setArchiveManifestDocuments(true);
        if (Utils.isArrayNotEmpty(excludedFilenames)) {
            asicContentDocumentFilter.setExcludedFilenames(Arrays.asList(excludedFilenames));
        }
        return asicContentDocumentFilter;
    }

    public static ASiCContentDocumentFilter allSupportedDocumentsFilter(String ... excludedFilenames) {
        ASiCContentDocumentFilter asicContentDocumentFilter = new ASiCContentDocumentFilter();
        asicContentDocumentFilter.setSignedDocuments(true);
        asicContentDocumentFilter.setSignatureDocuments(true);
        asicContentDocumentFilter.setTimestampDocuments(true);
        asicContentDocumentFilter.setEvidenceRecordDocuments(true);
        asicContentDocumentFilter.setManifestDocuments(true);
        asicContentDocumentFilter.setArchiveManifestDocuments(true);
        asicContentDocumentFilter.setEvidenceRecordManifestDocuments(true);
        if (Utils.isArrayNotEmpty(excludedFilenames)) {
            asicContentDocumentFilter.setExcludedFilenames(Arrays.asList(excludedFilenames));
        }
        return asicContentDocumentFilter;
    }

    public static ASiCContentDocumentFilter allDocumentsFilter(String ... excludedFilenames) {
        ASiCContentDocumentFilter asicContentDocumentFilter = new ASiCContentDocumentFilter();
        asicContentDocumentFilter.setMimetypeDocument(true);
        asicContentDocumentFilter.setSignedDocuments(true);
        asicContentDocumentFilter.setSignatureDocuments(true);
        asicContentDocumentFilter.setTimestampDocuments(true);
        asicContentDocumentFilter.setEvidenceRecordDocuments(true);
        asicContentDocumentFilter.setManifestDocuments(true);
        asicContentDocumentFilter.setArchiveManifestDocuments(true);
        asicContentDocumentFilter.setEvidenceRecordManifestDocuments(true);
        asicContentDocumentFilter.setUnsupportedDocuments(true);
        if (Utils.isArrayNotEmpty(excludedFilenames)) {
            asicContentDocumentFilter.setExcludedFilenames(Arrays.asList(excludedFilenames));
        }
        return asicContentDocumentFilter;
    }

    public static ASiCContentDocumentFilter allowedFilenamesFilter(String ... allowedFilenames) {
        ASiCContentDocumentFilter asicContentDocumentFilter = new ASiCContentDocumentFilter();
        if (Utils.isArrayNotEmpty(allowedFilenames)) {
            asicContentDocumentFilter.setIncludedFilenames(Arrays.asList(allowedFilenames));
        }
        return asicContentDocumentFilter;
    }
}

