/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestParser;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASiCWithCAdESUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCWithCAdESUtils.class);
    public static final String DEFAULT_ARCHIVE_MANIFEST_FILENAME = "META-INF/ASiCArchiveManifest.xml";

    private ASiCWithCAdESUtils() {
    }

    public static DSSDocument getSignedDocument(ASiCContent extractResult, String signatureFilename) {
        ASiCContainerType type = extractResult.getContainerType();
        if (ASiCContainerType.ASiC_S.equals((Object)type) && extractResult.getRootLevelSignedDocuments().size() == 1) {
            return extractResult.getRootLevelSignedDocuments().iterator().next();
        }
        if (ASiCContainerType.ASiC_E.equals((Object)type)) {
            List<DSSDocument> manifestDocuments = extractResult.getManifestDocuments();
            if (manifestDocuments.size() == 1) {
                return manifestDocuments.iterator().next();
            }
            DSSDocument linkedManifest = ASiCManifestParser.getLinkedManifest(extractResult.getManifestDocuments(), signatureFilename);
            if (linkedManifest != null) {
                return linkedManifest;
            }
            return null;
        }
        LOG.warn("Unable to extract a signed document. Reason : Unknown asic container type.");
        return null;
    }
}

