/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.cades.extract.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESUtils;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.signature.ASiCSignatureExtensionHelper;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestParser;
import eu.europa.esig.dss.cades.validation.CMSDocumentAnalyzer;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.spi.validation.analyzer.DocumentAnalyzer;
import java.util.Collections;
import java.util.List;

public class ASiCWithCAdESSignatureExtensionHelper
extends ASiCSignatureExtensionHelper {
    protected ASiCWithCAdESSignatureExtensionHelper(DSSDocument asicContainer) {
        super(asicContainer);
    }

    protected ASiCWithCAdESSignatureExtensionHelper(ASiCContent asicContent) {
        super(asicContent);
    }

    @Override
    protected DefaultASiCContainerExtractor getASiCContainerExtractor(DSSDocument asicContainer) {
        return new ASiCWithCAdESContainerExtractor(asicContainer);
    }

    @Override
    protected DocumentAnalyzer getDocumentAnalyzer(DSSDocument signatureDocument) {
        return new CMSDocumentAnalyzer(signatureDocument);
    }

    @Override
    public List<DSSDocument> getDetachedDocuments(String signatureFilename) {
        DSSDocument signedDocument = ASiCWithCAdESUtils.getSignedDocument(this.getAsicContent(), signatureFilename);
        if (signedDocument != null) {
            return Collections.singletonList(signedDocument);
        }
        return Collections.emptyList();
    }

    @Override
    public ManifestFile getManifestFile(String signatureFilename) {
        DSSDocument signatureManifest = ASiCManifestParser.getLinkedManifest(this.getAsicContent().getAllManifestDocuments(), signatureFilename);
        if (signatureManifest != null) {
            return ASiCManifestParser.getManifestFile(signatureManifest);
        }
        return null;
    }
}

