/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail;

import com.sanctionco.jmail.Email;
import com.sanctionco.jmail.EmailValidationResult;
import com.sanctionco.jmail.EmailValidator;
import com.sanctionco.jmail.FailureReason;
import com.sanctionco.jmail.InvalidEmailException;
import com.sanctionco.jmail.net.InternetProtocolAddress;
import java.net.IDN;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class JMail {
    private static final String IPV6_PREFIX = "IPv6:";
    private static final Set<Character> DISALLOWED_UNQUOTED_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('\t'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(','), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('@'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('\"'), Character.valueOf('\u2401'), Character.valueOf('\u2402'), Character.valueOf('\u2403'), Character.valueOf('\u2404'), Character.valueOf('\u2405'), Character.valueOf('\u2406'), Character.valueOf('\u2407'), Character.valueOf('\u2408'), Character.valueOf('\u240b'), Character.valueOf('\u240c'), Character.valueOf('\u240e'), Character.valueOf('\u240f'), Character.valueOf('\u2410'), Character.valueOf('\u2411'), Character.valueOf('\u2412'), Character.valueOf('\u2413'), Character.valueOf('\u2414'), Character.valueOf('\u2415'), Character.valueOf('\u2416'), Character.valueOf('\u2417'), Character.valueOf('\u2418'), Character.valueOf('\u2419'), Character.valueOf('\u241a'), Character.valueOf('\u241b'), Character.valueOf('\u241c'), Character.valueOf('\u241d'), Character.valueOf('\u241f'), Character.valueOf('\u2401')));
    private static final Set<Byte> DISALLOWED_UNQUOTED_CHARACTER_TYPES = new HashSet<Byte>(Arrays.asList((byte)23, (byte)20, (byte)21, (byte)22, (byte)29, (byte)30, (byte)24, (byte)25, (byte)26, (byte)27, (byte)28));
    private static final Set<Character> ALLOWED_DOMAIN_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf(' ')));
    private static final Set<Character> ALLOWED_QUOTED_WITH_ESCAPE = new HashSet<Character>(Arrays.asList(Character.valueOf('\r'), Character.valueOf('\u2400'), Character.valueOf('\n')));

    private JMail() {
    }

    public static EmailValidator validator() {
        return new EmailValidator();
    }

    public static EmailValidator strictValidator() {
        return new EmailValidator().disallowIpDomain().requireTopLevelDomain().disallowExplicitSourceRouting();
    }

    public static boolean isValid(String email) {
        return JMail.tryParse(email).isPresent();
    }

    public static boolean isInvalid(String email) {
        return !JMail.tryParse(email).isPresent();
    }

    public static void enforceValid(String email) throws InvalidEmailException {
        if (!JMail.tryParse(email).isPresent()) {
            throw new InvalidEmailException();
        }
    }

    public static Optional<Email> tryParse(String email) {
        EmailValidationResult result = JMail.validate(email);
        return result.getEmail();
    }

    public static EmailValidationResult validate(String email) {
        return JMail.validateInternal(email, false);
    }

    static EmailValidationResult validate(String email, boolean allowNonstandardDots) {
        return JMail.validateInternal(email, allowNonstandardDots);
    }

    private static EmailValidationResult validateInternal(String email, boolean allowNonstandardDots) {
        int size;
        if (email == null) {
            return EmailValidationResult.failure(FailureReason.NULL_ADDRESS);
        }
        if (email.length() < 3) {
            return EmailValidationResult.failure(FailureReason.ADDRESS_TOO_SHORT);
        }
        List sourceRoutes = Collections.emptyList();
        String fullSourceRoute = "";
        if (email.charAt(0) == '@') {
            Optional<SourceRouteDetail> sourceRoute = JMail.validateSourceRouting(email);
            if (!sourceRoute.isPresent()) {
                return EmailValidationResult.failure(FailureReason.BEGINS_WITH_AT_SYMBOL);
            }
            SourceRouteDetail detail = sourceRoute.get();
            sourceRoutes = detail.routes;
            fullSourceRoute = detail.fullRoute.toString();
            if ((email = email.substring(fullSourceRoute.length())).isEmpty()) {
                return EmailValidationResult.failure(FailureReason.BEGINS_WITH_AT_SYMBOL);
            }
        }
        if ((size = email.length()) > 320) {
            return EmailValidationResult.failure(FailureReason.ADDRESS_TOO_LONG);
        }
        if (email.charAt(size - 1) == '.') {
            return EmailValidationResult.failure(FailureReason.ENDS_WITH_DOT);
        }
        if (email.charAt(size - 1) == '-') {
            return EmailValidationResult.failure(FailureReason.DOMAIN_PART_ENDS_WITH_DASH);
        }
        boolean startsWithDot = false;
        boolean atFound = false;
        boolean inQuotes = false;
        boolean previousDot = false;
        boolean previousBackslash = false;
        boolean firstDomainChar = true;
        boolean isIpAddress = false;
        boolean requireAtOrDot = false;
        boolean requireAtDotOrComment = false;
        boolean whitespace = false;
        boolean previousComment = false;
        boolean requireAngledBracket = false;
        boolean containsWhiteSpace = false;
        boolean isAscii = true;
        boolean removableQuotePair = true;
        boolean previousQuotedDot = false;
        boolean requireQuotedDot = false;
        StringBuilder localPart = new StringBuilder(size);
        StringBuilder localPartWithoutComments = new StringBuilder(size);
        StringBuilder localPartWithoutQuotes = new StringBuilder(size);
        StringBuilder currentQuote = new StringBuilder();
        StringBuilder domain = new StringBuilder(size);
        StringBuilder domainWithoutComments = new StringBuilder(size);
        StringBuilder currentDomainPart = new StringBuilder();
        ArrayList<String> domainParts = new ArrayList<String>();
        ArrayList<String> comments = new ArrayList<String>();
        int localPartCommentLength = 0;
        int domainCommentLength = 0;
        int charactersOnLine = 1;
        for (int i = 0; i < size; ++i) {
            boolean quotedWhitespace;
            char c = email.charAt(i);
            if (c >= '\u0080') {
                isAscii = false;
            }
            if (i == 0 && c == '.' && !allowNonstandardDots) {
                startsWithDot = true;
            }
            if (c == '<' && !inQuotes && !previousBackslash) {
                if (email.charAt(size - 1) != '>') {
                    return EmailValidationResult.failure(FailureReason.UNQUOTED_ANGLED_BRACKET);
                }
                EmailValidationResult innerResult = JMail.validateInternal(email.substring(i + 1, size - 1), allowNonstandardDots);
                return innerResult.getEmail().map(e -> EmailValidationResult.success(new Email((Email)e, localPart.toString()))).orElse(innerResult);
            }
            if (c == '@' && !inQuotes && !previousBackslash) {
                if (atFound) {
                    return EmailValidationResult.failure(FailureReason.MULTIPLE_AT_SYMBOLS);
                }
                if (requireAngledBracket) {
                    return EmailValidationResult.failure(FailureReason.INVALID_WHITESPACE);
                }
                atFound = true;
                requireAtDotOrComment = false;
                requireAtOrDot = false;
                whitespace = false;
                previousDot = true;
                continue;
            }
            if (c == '\n') {
                if (charactersOnLine <= 0) {
                    return EmailValidationResult.failure(FailureReason.INVALID_WHITESPACE);
                }
                charactersOnLine = 0;
            } else if (c != '\r') {
                ++charactersOnLine;
            }
            if (requireAtOrDot) {
                if (!JMail.isWhitespace(c) && c != '.') {
                    return EmailValidationResult.failure(FailureReason.INVALID_COMMENT_LOCATION);
                }
                requireAtOrDot = false;
            }
            if (requireAtDotOrComment) {
                if (!JMail.isWhitespace(c) && c != '.' && c != '(') {
                    return EmailValidationResult.failure(FailureReason.INVALID_QUOTE_LOCATION);
                }
                requireAtDotOrComment = false;
            }
            if (whitespace && !previousDot && !previousComment && c != '.' && c != '(' && !JMail.isWhitespace(c)) {
                if (!atFound) {
                    requireAngledBracket = true;
                } else {
                    return EmailValidationResult.failure(FailureReason.INVALID_WHITESPACE);
                }
            }
            if (requireQuotedDot && inQuotes) {
                if (c != '.' && !JMail.isWhitespace(c) && c != '\"') {
                    removableQuotePair = false;
                } else if (!JMail.isWhitespace(c) && c != '\"') {
                    requireQuotedDot = false;
                }
            }
            if (c == '(' && inQuotes && !previousBackslash) {
                removableQuotePair = false;
            }
            if (c == '(' && !inQuotes) {
                Optional<String> comment = JMail.validateComment(email.substring(i));
                if (!comment.isPresent()) {
                    return EmailValidationResult.failure(FailureReason.INVALID_COMMENT);
                }
                String commentStr = comment.get();
                int commentStrLen = commentStr.length();
                if (!atFound && i != 0 && !previousDot) {
                    requireAtOrDot = true;
                } else if (atFound && !firstDomainChar && !previousDot && i + commentStrLen != size) {
                    requireAtOrDot = true;
                }
                i += commentStrLen - 1;
                if (!atFound) {
                    localPart.append(commentStr);
                    localPartCommentLength += commentStrLen;
                } else {
                    domain.append(commentStr);
                    domainCommentLength += commentStrLen;
                }
                previousComment = true;
                comments.add(commentStr.substring(1, commentStrLen - 1));
                continue;
            }
            if (c == '.' && previousDot) {
                if (!inQuotes) {
                    return EmailValidationResult.failure(FailureReason.MULTIPLE_DOT_SEPARATORS);
                }
                removableQuotePair = false;
            }
            if (!atFound) {
                byte type;
                if (c == '\"' && i > 0 && !previousDot && !inQuotes) {
                    return EmailValidationResult.failure(FailureReason.INVALID_QUOTE_LOCATION);
                }
                boolean mustBeQuoted = DISALLOWED_UNQUOTED_CHARACTERS.contains(Character.valueOf(c));
                if (c != '\"' && !inQuotes && !previousBackslash && mustBeQuoted) {
                    return EmailValidationResult.failure(FailureReason.DISALLOWED_UNQUOTED_CHARACTER);
                }
                if (mustBeQuoted && inQuotes && !previousBackslash && c != '\"') {
                    removableQuotePair = false;
                }
                if (c >= '\u0080' && !inQuotes && !previousBackslash && DISALLOWED_UNQUOTED_CHARACTER_TYPES.contains(type = (byte)Character.getType(c))) {
                    return EmailValidationResult.failure(FailureReason.DISALLOWED_UNQUOTED_CHARACTER);
                }
                if (!inQuotes && previousBackslash && !mustBeQuoted && c != ' ' && c != '\\') {
                    return EmailValidationResult.failure(FailureReason.UNUSED_BACKSLASH_ESCAPE);
                }
                if (inQuotes && ALLOWED_QUOTED_WITH_ESCAPE.contains(Character.valueOf(c))) {
                    if (!previousBackslash) {
                        return EmailValidationResult.failure(FailureReason.MISSING_BACKSLASH_ESCAPE);
                    }
                    removableQuotePair = false;
                }
                localPart.append(c);
                localPartWithoutComments.append(c);
                if (c != '\"') {
                    if (inQuotes) {
                        currentQuote.append(c);
                    } else {
                        localPartWithoutQuotes.append(c);
                    }
                }
            } else {
                if (startsWithDot) {
                    return EmailValidationResult.failure(FailureReason.STARTS_WITH_DOT);
                }
                if (firstDomainChar && c == '[') {
                    Optional<String> validatedIp;
                    String ipDomain = email.substring(i);
                    if (!ipDomain.endsWith("]") || ipDomain.length() < 3) {
                        return EmailValidationResult.failure(FailureReason.INVALID_IP_DOMAIN);
                    }
                    String ip = ipDomain.substring(1, ipDomain.length() - 1);
                    Optional<String> optional = validatedIp = ip.startsWith(IPV6_PREFIX) ? InternetProtocolAddress.validateIpv6(ip.substring(IPV6_PREFIX.length())).map(s -> IPV6_PREFIX + s) : InternetProtocolAddress.validateIpv4(ip);
                    if (!validatedIp.isPresent()) {
                        return EmailValidationResult.failure(FailureReason.INVALID_IP_DOMAIN);
                    }
                    currentDomainPart.append(validatedIp.get());
                    domain.append(validatedIp.get());
                    domainWithoutComments.append(validatedIp.get());
                    isIpAddress = true;
                    break;
                }
                if (c == '.') {
                    if (currentDomainPart.length() > 63) {
                        return EmailValidationResult.failure(FailureReason.DOMAIN_PART_TOO_LONG);
                    }
                    if (currentDomainPart.charAt(0) == '-') {
                        return EmailValidationResult.failure(FailureReason.DOMAIN_PART_STARTS_WITH_DASH);
                    }
                    if (currentDomainPart.charAt(currentDomainPart.length() - 1) == '-') {
                        return EmailValidationResult.failure(FailureReason.DOMAIN_PART_ENDS_WITH_DASH);
                    }
                    domainParts.add(currentDomainPart.toString());
                    currentDomainPart = new StringBuilder();
                } else if (!JMail.isWhitespace(c)) {
                    currentDomainPart.append(c);
                }
                domain.append(c);
                domainWithoutComments.append(c);
                firstDomainChar = false;
            }
            boolean bl = quotedWhitespace = JMail.isWhitespace(c) && inQuotes;
            if (c == '\"' && !previousBackslash) {
                if (inQuotes) {
                    requireAtDotOrComment = true;
                    if (currentQuote.length() == 0) {
                        removableQuotePair = false;
                    }
                    if (removableQuotePair) {
                        localPartWithoutQuotes.append((CharSequence)currentQuote);
                    } else {
                        localPartWithoutQuotes.append('\"');
                        localPartWithoutQuotes.append((CharSequence)currentQuote);
                        localPartWithoutQuotes.append('\"');
                    }
                } else {
                    removableQuotePair = true;
                    currentQuote = new StringBuilder();
                }
                inQuotes = !inQuotes;
            }
            boolean bl2 = whitespace = JMail.isWhitespace(c) && !inQuotes && !previousBackslash;
            if (whitespace) {
                containsWhiteSpace = true;
            }
            if (!whitespace) {
                boolean bl3 = previousDot = c == '.';
            }
            if (!quotedWhitespace) {
                boolean bl4 = previousQuotedDot = c == '.';
            }
            if (quotedWhitespace && !previousQuotedDot && !previousBackslash) {
                requireQuotedDot = true;
            }
            previousBackslash = c == '\\' && !previousBackslash;
        }
        if (!atFound) {
            return EmailValidationResult.failure(FailureReason.MISSING_AT_SYMBOL);
        }
        int localPartLen = localPart.length() - localPartCommentLength;
        if (localPartLen == 0) {
            return EmailValidationResult.failure(FailureReason.LOCAL_PART_MISSING);
        }
        if (localPartLen > 64) {
            return EmailValidationResult.failure(FailureReason.LOCAL_PART_TOO_LONG);
        }
        int domainLen = domain.length() - domainCommentLength;
        if (domainLen == 0) {
            return EmailValidationResult.failure(FailureReason.DOMAIN_MISSING);
        }
        if (domainLen > 255) {
            return EmailValidationResult.failure(FailureReason.DOMAIN_TOO_LONG);
        }
        if (localPart.charAt(localPart.length() - 1) == '.') {
            if (!allowNonstandardDots) {
                return EmailValidationResult.failure(FailureReason.LOCAL_PART_ENDS_WITH_DOT);
            }
            if (localPartLen <= 1) {
                return EmailValidationResult.failure(FailureReason.LOCAL_PART_MISSING);
            }
        }
        if (currentDomainPart.length() <= 0) {
            return EmailValidationResult.failure(FailureReason.MISSING_FINAL_DOMAIN_PART);
        }
        if (currentDomainPart.length() > 63) {
            return EmailValidationResult.failure(FailureReason.TOP_LEVEL_DOMAIN_TOO_LONG);
        }
        if (currentDomainPart.charAt(0) == '-') {
            return EmailValidationResult.failure(FailureReason.DOMAIN_PART_STARTS_WITH_DASH);
        }
        String tld = currentDomainPart.toString();
        if (tld.chars().allMatch(Character::isDigit)) {
            return EmailValidationResult.failure(FailureReason.NUMERIC_TLD);
        }
        domainParts.add(tld);
        if (!isIpAddress && !JMail.isValidIdn(domainWithoutComments.toString())) {
            return EmailValidationResult.failure(FailureReason.INVALID_DOMAIN_CHARACTER);
        }
        Email parsed = new Email(localPart.toString(), localPartWithoutComments.toString(), localPartWithoutQuotes.toString(), domain.toString(), domainWithoutComments.toString(), fullSourceRoute, domainParts, comments, sourceRoutes, isIpAddress, containsWhiteSpace, isAscii);
        return EmailValidationResult.success(parsed);
    }

    private static Optional<String> validateComment(String s) {
        if (s.length() < 2) {
            return Optional.empty();
        }
        StringBuilder builder = new StringBuilder(s.length());
        boolean previousBackslash = false;
        boolean foundClosingParenthesis = false;
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (c == '(' && !previousBackslash && i != 0) {
                Optional<String> inner = JMail.validateComment(s.substring(i));
                if (!inner.isPresent()) {
                    return Optional.empty();
                }
                i += inner.get().length() - 1;
                builder.append(inner.get());
                continue;
            }
            builder.append(c);
            if (c == ')' && !previousBackslash) {
                foundClosingParenthesis = true;
                break;
            }
            previousBackslash = c == '\\';
        }
        if (!foundClosingParenthesis) {
            return Optional.empty();
        }
        return Optional.of(builder.toString());
    }

    private static Optional<SourceRouteDetail> validateSourceRouting(String s) {
        boolean requireNewDomain = true;
        SourceRouteDetail detail = new SourceRouteDetail();
        StringBuilder sourceRoute = new StringBuilder();
        StringBuilder currentDomainPart = new StringBuilder();
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (requireNewDomain && c != '@') {
                return Optional.empty();
            }
            if (c == '@' && !requireNewDomain) {
                return Optional.empty();
            }
            if (c == '.' || c == ',' || c == ':') {
                if (currentDomainPart.length() == 0 || currentDomainPart.length() > 63) {
                    return Optional.empty();
                }
                if (currentDomainPart.charAt(0) == '-' || currentDomainPart.charAt(currentDomainPart.length() - 1) == '-') {
                    return Optional.empty();
                }
                if ((c == ',' || c == ':') && currentDomainPart.toString().chars().allMatch(Character::isDigit)) {
                    return Optional.empty();
                }
                currentDomainPart = new StringBuilder();
            } else if (c != '@') {
                currentDomainPart.append(c);
            }
            requireNewDomain = c == ',';
            detail.fullRoute.append(c);
            if (c == ',' || c == ':') {
                String route = sourceRoute.toString();
                if (!JMail.isValidIdn(route)) {
                    return Optional.empty();
                }
                detail.routes.add(route);
                sourceRoute = new StringBuilder();
            } else if (c != '@') {
                sourceRoute.append(c);
            }
            if (c == ':') break;
        }
        if (currentDomainPart.length() > 0) {
            return Optional.empty();
        }
        if (sourceRoute.length() > 0) {
            return Optional.empty();
        }
        if (requireNewDomain) {
            return Optional.empty();
        }
        return Optional.of(detail);
    }

    private static boolean isValidIdn(String test) {
        String domain;
        try {
            domain = IDN.toASCII(test, 1);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        int size = domain.length();
        for (int i = 0; i < size; ++i) {
            char c = domain.charAt(i);
            if (ALLOWED_DOMAIN_CHARACTERS.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\r';
    }

    private static final class SourceRouteDetail {
        private final StringBuilder fullRoute = new StringBuilder();
        private final List<String> routes = new ArrayList<String>();

        private SourceRouteDetail() {
        }
    }
}

