/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail;

import com.sanctionco.jmail.JMail;
import com.sanctionco.jmail.TopLevelDomain;
import com.sanctionco.jmail.normalization.CaseOption;
import com.sanctionco.jmail.normalization.NormalizationOptions;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Normalizer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Email {
    private final String localPart;
    private final String localPartWithoutComments;
    private final String localPartWithoutQuotes;
    private final String domain;
    private final String domainWithoutComments;
    private final String fullSourceRoute;
    private final String identifier;
    private final List<String> domainParts;
    private final List<String> comments;
    private final List<String> sourceRoutes;
    private final boolean isIpAddress;
    private final boolean containsWhitespace;
    private final boolean isAscii;
    private final boolean hasIdentifier;
    private final TopLevelDomain tld;

    Email(String localPart, String localPartWithoutComments, String localPartWithoutQuotes, String domain, String domainWithoutComments, String fullSourceRoute, List<String> domainParts, List<String> comments, List<String> sourceRoutes, boolean isIpAddress, boolean containsWhitespace, boolean isAscii) {
        this.localPart = localPart;
        this.localPartWithoutComments = localPartWithoutComments;
        this.localPartWithoutQuotes = localPartWithoutQuotes;
        this.domain = domain;
        this.domainWithoutComments = domainWithoutComments;
        this.fullSourceRoute = fullSourceRoute;
        this.domainParts = Collections.unmodifiableList(domainParts);
        this.comments = Collections.unmodifiableList(comments);
        this.sourceRoutes = Collections.unmodifiableList(sourceRoutes);
        this.isIpAddress = isIpAddress;
        this.containsWhitespace = containsWhitespace;
        this.isAscii = isAscii;
        this.identifier = null;
        this.hasIdentifier = false;
        this.tld = domainParts.size() > 1 ? TopLevelDomain.fromString(domainParts.get(domainParts.size() - 1)) : TopLevelDomain.NONE;
    }

    Email(Email other, String identifier) {
        this.localPart = other.localPart;
        this.localPartWithoutComments = other.localPartWithoutComments;
        this.localPartWithoutQuotes = other.localPartWithoutQuotes;
        this.domain = other.domain;
        this.domainWithoutComments = other.domainWithoutComments;
        this.fullSourceRoute = other.fullSourceRoute;
        this.identifier = identifier;
        this.domainParts = other.domainParts;
        this.comments = other.comments;
        this.sourceRoutes = other.sourceRoutes;
        this.isIpAddress = other.isIpAddress;
        this.containsWhitespace = other.containsWhitespace;
        this.isAscii = other.isAscii;
        this.hasIdentifier = identifier != null && identifier.length() > 0;
        this.tld = other.tld;
    }

    public static Optional<Email> of(String email) {
        return JMail.tryParse(email);
    }

    public String localPart() {
        return this.localPart;
    }

    public String localPartWithoutComments() {
        return this.localPartWithoutComments;
    }

    public String domain() {
        return this.domain;
    }

    public String domainWithoutComments() {
        return this.domainWithoutComments;
    }

    public String identifier() {
        return this.identifier;
    }

    public List<String> domainParts() {
        return this.domainParts;
    }

    public List<String> comments() {
        return this.comments;
    }

    public List<String> explicitSourceRoutes() {
        return this.sourceRoutes;
    }

    public boolean isIpAddress() {
        return this.isIpAddress;
    }

    public boolean containsWhitespace() {
        return this.containsWhitespace;
    }

    public boolean isAscii() {
        return this.isAscii;
    }

    public boolean hasIdentifier() {
        return this.hasIdentifier;
    }

    public TopLevelDomain topLevelDomain() {
        return this.tld;
    }

    public String normalized() {
        return this.normalized(NormalizationOptions.DEFAULT_OPTIONS);
    }

    public String normalized(NormalizationOptions options) {
        return this.normalizedLocalPart(options) + "@" + this.normalizedDomain(options);
    }

    public String reference() throws NoSuchAlgorithmException {
        return this.reference(NormalizationOptions.DEFAULT_OPTIONS);
    }

    public String reference(NormalizationOptions options) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] normalized = this.normalized(options).getBytes(StandardCharsets.UTF_8);
        byte[] digest = md.digest(normalized);
        return this.toHexString(digest);
    }

    public String redacted() throws NoSuchAlgorithmException {
        return this.redacted(NormalizationOptions.DEFAULT_OPTIONS);
    }

    public String redacted(NormalizationOptions options) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] normalizedLocalPart = this.normalizedLocalPart(options).getBytes(StandardCharsets.UTF_8);
        byte[] digest = md.digest(normalizedLocalPart);
        return "{" + this.toHexString(digest) + "}@" + this.normalizedDomain(options);
    }

    public String munged() {
        return this.munged(NormalizationOptions.DEFAULT_OPTIONS);
    }

    public String munged(NormalizationOptions options) {
        String localPart = this.normalizedLocalPart(options);
        localPart = localPart.length() < 2 ? localPart : localPart.substring(0, 2);
        String domain = this.normalizedDomain(options);
        domain = domain.length() < 2 ? domain : domain.substring(0, 2);
        return localPart + "*****@" + domain + "*****";
    }

    private String normalizedLocalPart(NormalizationOptions options) {
        int separatorIndex;
        String localPart;
        String string = localPart = options.shouldStripQuotes() ? this.localPartWithoutQuotes : this.localPartWithoutComments;
        if (options.shouldRemoveSubAddress() && (separatorIndex = localPart.indexOf(options.getSubAddressSeparator())) != -1) {
            localPart = localPart.substring(0, separatorIndex);
        }
        CaseOption caseOption = options.getCaseOption();
        String string2 = localPart = options.shouldRemoveDots() ? caseOption.adjustLocalPart(localPart.replace(".", "")) : caseOption.adjustLocalPart(localPart);
        if (options.shouldPerformUnicodeNormalization()) {
            localPart = Normalizer.normalize(localPart, options.getUnicodeNormalizationForm());
        }
        return localPart;
    }

    private String normalizedDomain(NormalizationOptions options) {
        CaseOption caseOption = options.getCaseOption();
        return this.isIpAddress ? "[" + this.domainWithoutComments + "]" : caseOption.adjustDomain(this.domainWithoutComments);
    }

    private String toHexString(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v / 16];
            hexChars[j * 2 + 1] = hexArray[v % 16];
        }
        return new String(hexChars);
    }

    public String toString() {
        String fixedDomain = this.isIpAddress ? "[" + this.domain + "]" : this.domain;
        String fixedLocalPart = this.fullSourceRoute + this.localPart;
        String addr = fixedLocalPart + "@" + fixedDomain;
        return this.hasIdentifier ? this.identifier + "<" + addr + ">" : addr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Email)) {
            return false;
        }
        Email email = (Email)o;
        return Objects.equals(this.localPart, email.localPart) && Objects.equals(this.localPartWithoutComments, email.localPartWithoutComments) && Objects.equals(this.localPartWithoutQuotes, email.localPartWithoutQuotes) && Objects.equals(this.domain, email.domain) && Objects.equals(this.domainWithoutComments, email.domainWithoutComments) && Objects.equals(this.fullSourceRoute, email.fullSourceRoute) && Objects.equals(this.identifier, email.identifier) && Objects.equals(this.domainParts, email.domainParts) && Objects.equals(this.sourceRoutes, email.sourceRoutes) && Objects.equals(this.comments, email.comments) && Objects.equals(this.isIpAddress, email.isIpAddress) && Objects.equals(this.containsWhitespace, email.containsWhitespace) && Objects.equals(this.isAscii, email.isAscii) && Objects.equals(this.hasIdentifier, email.hasIdentifier) && Objects.equals(this.tld, email.tld);
    }

    public int hashCode() {
        return Objects.hash(this.localPart, this.localPartWithoutComments, this.localPartWithoutQuotes, this.domain, this.domainWithoutComments, this.fullSourceRoute, this.identifier, this.domainParts, this.sourceRoutes, this.comments, this.isIpAddress, this.containsWhitespace, this.isAscii, this.hasIdentifier, this.tld);
    }
}

