/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.JsonParseException;
import com.github.erosb.jsonsKema.SourceWalker;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\tH\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/erosb/jsonsKema/StringReadingSourceWalker;", "Lcom/github/erosb/jsonsKema/SourceWalker;", "input", "", "documentSource", "Ljava/net/URI;", "<init>", "([CLjava/net/URI;)V", "inputSize", "", "pos", "readCharInto", "forward", "", "curr", "", "currInt", "mark", "reset", "reachedEOF", "", "hasAtLeastNRemainingChars", "n", "unsafeCurr", "json-sKema"})
public final class StringReadingSourceWalker
extends SourceWalker {
    @NotNull
    private final char[] input;
    private final int inputSize;
    private int pos;

    public StringReadingSourceWalker(@NotNull char[] input, @NotNull URI documentSource) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(documentSource, "documentSource");
        super(documentSource);
        this.input = input;
        this.inputSize = this.input.length;
    }

    @Override
    public int readCharInto() {
        if (this.reachedEOF()) {
            return -1;
        }
        int n = this.pos;
        this.pos = n + 1;
        this.getBuf()[0] = this.input[n];
        this.setPosition(this.getPosition() + 1);
        this.getPosition();
        return 1;
    }

    @Override
    public void forward() {
        ++this.pos;
        this.setPosition(this.getPosition() + 1);
        this.getPosition();
    }

    @Override
    public char curr() {
        if (this.reachedEOF()) {
            throw new JsonParseException("Unexpected EOF", this.getLocation());
        }
        return this.input[this.pos];
    }

    @Override
    public int currInt() {
        if (this.reachedEOF()) {
            return -1;
        }
        return this.input[this.pos];
    }

    @Override
    public void mark() {
    }

    @Override
    public void reset() {
        this.setPosition(this.getPosition() + -1);
        this.getPosition();
        this.pos += -1;
    }

    @Override
    public boolean reachedEOF() {
        return this.pos == this.inputSize;
    }

    @Override
    public boolean hasAtLeastNRemainingChars(int n) {
        return this.inputSize - this.pos > n;
    }

    @Override
    public char unsafeCurr() {
        return this.input[this.pos];
    }
}

