/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.JsonParseException;
import com.github.erosb.jsonsKema.TextLocation;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u000bH&J\b\u0010\u001b\u001a\u00020\u0014H&J\b\u0010\u001c\u001a\u00020\u0019H&J\b\u0010\u001d\u001a\u00020\u000bH&J\b\u0010\u001e\u001a\u00020\u0014H&J\b\u0010\u001f\u001a\u00020\u0014H&J\b\u0010 \u001a\u00020!H&J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u000bH&J\b\u0010$\u001a\u00020\u0019H&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lcom/github/erosb/jsonsKema/SourceWalker;", "", "documentSource", "Ljava/net/URI;", "<init>", "(Ljava/net/URI;)V", "buf", "", "getBuf", "()[C", "lineNumber", "", "getLineNumber", "()I", "setLineNumber", "(I)V", "position", "getPosition", "setPosition", "skipWhitespaces", "", "consume", "token", "", "expected", "", "readCharInto", "forward", "curr", "currInt", "mark", "reset", "reachedEOF", "", "hasAtLeastNRemainingChars", "n", "unsafeCurr", "location", "Lcom/github/erosb/jsonsKema/TextLocation;", "getLocation", "()Lcom/github/erosb/jsonsKema/TextLocation;", "json-sKema"})
public abstract class SourceWalker {
    @NotNull
    private final URI documentSource;
    @NotNull
    private final char[] buf;
    private int lineNumber;
    private int position;

    public SourceWalker(@NotNull URI documentSource) {
        Intrinsics.checkNotNullParameter(documentSource, "documentSource");
        this.documentSource = documentSource;
        this.buf = new char[1];
        this.lineNumber = 1;
        this.position = 1;
    }

    @NotNull
    protected final char[] getBuf() {
        return this.buf;
    }

    protected final int getLineNumber() {
        return this.lineNumber;
    }

    protected final void setLineNumber(int n) {
        this.lineNumber = n;
    }

    protected final int getPosition() {
        return this.position;
    }

    protected final void setPosition(int n) {
        this.position = n;
    }

    public final void skipWhitespaces() {
        char c;
        while (this.hasAtLeastNRemainingChars(64)) {
            int ctr = 63;
            while (ctr-- > 0) {
                c = this.unsafeCurr();
                if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                    return;
                }
                this.forward();
                if (c == '\r' && this.unsafeCurr() == '\n') {
                    this.forward();
                }
                switch (c) {
                    case '\n': 
                    case '\r': {
                        this.position = 1;
                        ++this.lineNumber;
                    }
                }
            }
        }
        while (true) {
            this.mark();
            int c2 = this.readCharInto();
            c = this.buf[0];
            if (c2 == -1) break;
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                this.reset();
                break;
            }
            if (c == '\r' && this.currInt() == 10) {
                this.forward();
            }
            switch (c) {
                case '\n': 
                case '\r': {
                    this.position = 1;
                    ++this.lineNumber;
                }
            }
        }
    }

    public final void consume(@NotNull String token) {
        Intrinsics.checkNotNullParameter(token, "token");
        char[] cArray = token.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        for (char expected : cArray) {
            char ch = this.curr();
            if (expected != ch) {
                throw new JsonParseException("Unexpected character found: " + ch, this.getLocation());
            }
            this.forward();
        }
    }

    public final void consume(char expected) {
        char ch = this.curr();
        if (expected != ch) {
            throw new JsonParseException("Unexpected character found: " + ch, this.getLocation());
        }
        this.forward();
    }

    public abstract int readCharInto();

    public abstract void forward();

    public abstract char curr();

    public abstract int currInt();

    public abstract void mark();

    public abstract void reset();

    public abstract boolean reachedEOF();

    public abstract boolean hasAtLeastNRemainingChars(int var1);

    public abstract char unsafeCurr();

    @NotNull
    public final TextLocation getLocation() {
        return new TextLocation(this.lineNumber, this.position, this.documentSource);
    }
}

