/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontConstants;
import com.sun.javafx.font.PrismFontFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

class FontFileWriter
implements FontConstants {
    byte[] header;
    int pos;
    int headerPos;
    File file;
    RandomAccessFile raFile;

    protected void setLength(int n) throws IOException {
        if (this.raFile == null) {
            throw new IOException("File not open");
        }
        this.raFile.setLength(n);
    }

    public void seek(int n) throws IOException {
        if (this.raFile == null) {
            throw new IOException("File not open");
        }
        if (n != this.pos) {
            this.raFile.seek(n);
            this.pos = n;
        }
    }

    public File getFile() {
        return this.file;
    }

    public File openFile() throws IOException {
        this.pos = 0;
        try {
            this.file = Files.createTempFile("+JXF", ".tmp", new FileAttribute[0]).toFile();
        }
        catch (IOException iOException) {
            throw new IOException("Unable to create temporary file");
        }
        this.raFile = new RandomAccessFile(this.file, "rw");
        if (PrismFontFactory.debugFonts) {
            System.err.println("Temp file created: " + this.file.getPath());
        }
        return this.file;
    }

    public void closeFile() throws IOException {
        if (this.header != null) {
            this.raFile.seek(0L);
            this.raFile.write(this.header);
            this.header = null;
        }
        if (this.raFile != null) {
            this.raFile.close();
            this.raFile = null;
        }
    }

    public void deleteFile() {
        if (this.file != null) {
            try {
                this.closeFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.file.delete();
                if (PrismFontFactory.debugFonts) {
                    System.err.println("Temp file delete: " + this.file.getPath());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.file = null;
            this.raFile = null;
        }
    }

    private void setHeaderPos(int n) {
        this.headerPos = n;
    }

    public void writeHeader(int n, short s) throws IOException {
        int n2 = 12 + 16 * s;
        this.header = new byte[n2];
        short s2 = s;
        s2 = (short)(s2 | s2 >> 1);
        s2 = (short)(s2 | s2 >> 2);
        s2 = (short)(s2 | s2 >> 4);
        s2 = (short)(s2 | s2 >> 8);
        short s3 = (short)(s2 * 16);
        short s4 = 0;
        for (s2 = (short)(s2 & (s2 >> 1 ^ 0xFFFFFFFF)); s2 > 1; s2 = (short)(s2 >> 1)) {
            s4 = (short)(s4 + 1);
        }
        short s5 = (short)(s * 16 - s3);
        this.setHeaderPos(0);
        this.writeInt(n);
        this.writeShort(s);
        this.writeShort(s3);
        this.writeShort(s4);
        this.writeShort(s5);
    }

    public void writeDirectoryEntry(int n, int n2, int n3, int n4, int n5) {
        this.setHeaderPos(12 + 16 * n);
        this.writeInt(n2);
        this.writeInt(n3);
        this.writeInt(n4);
        this.writeInt(n5);
    }

    private void writeInt(int n) {
        this.header[this.headerPos++] = (byte)((n & 0xFF000000) >> 24);
        this.header[this.headerPos++] = (byte)((n & 0xFF0000) >> 16);
        this.header[this.headerPos++] = (byte)((n & 0xFF00) >> 8);
        this.header[this.headerPos++] = (byte)(n & 0xFF);
    }

    private void writeShort(short s) {
        this.header[this.headerPos++] = (byte)((s & 0xFF00) >> 8);
        this.header[this.headerPos++] = (byte)(s & 0xFF);
    }

    public void writeBytes(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this.raFile.write(byArray, n, n2);
        this.pos += n2;
    }
}

